/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.ConsoleOutputCapture;
import org.apache.maven.surefire.report.DefaultConsoleOutputReceiver;
import org.apache.maven.surefire.report.DefaultDirectConsoleReporter;
import org.apache.maven.surefire.report.DirectConsoleReporter;
import org.apache.maven.surefire.report.MulticastingReporter;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.RunListener;
import org.apache.maven.surefire.report.RunReporter;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.report.SystemConsoleOutputReceiver;
import org.apache.maven.surefire.report.TestSetRunListener;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.SurefireReflectionException;

public class ReporterManagerFactory
implements ReporterFactory {
    private final List reportDefinitions;
    private final ClassLoader surefireClassLoader;
    private final RunStatistics globalRunStatistics = new RunStatistics();
    private final ReporterConfiguration reporterConfiguration;
    private RunReporter first;
    private final Object lock = new Object();
    private final ConsoleOutputCapture consoleOutputCapture;
    static /* synthetic */ Class class$org$apache$maven$surefire$report$ReporterConfiguration;

    public ReporterManagerFactory(ClassLoader surefireClassLoader, ReporterConfiguration reporterConfiguration) {
        this.reportDefinitions = reporterConfiguration.getReports();
        this.surefireClassLoader = surefireClassLoader;
        this.reporterConfiguration = reporterConfiguration;
        SystemConsoleOutputReceiver systemConsoleOutputReceiver = new SystemConsoleOutputReceiver(reporterConfiguration.getOriginalSystemOut(), reporterConfiguration.getOriginalSystemErr());
        DefaultConsoleOutputReceiver target = new DefaultConsoleOutputReceiver(systemConsoleOutputReceiver, true);
        this.consoleOutputCapture = new ConsoleOutputCapture(target);
    }

    public RunStatistics getGlobalRunStatistics() {
        return this.globalRunStatistics;
    }

    public RunListener createReporter() {
        return this.setupReporter(this.instantiateReportsNewStyle(this.reportDefinitions, this.reporterConfiguration, this.surefireClassLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunListener setupReporter(List reports) {
        TestSetRunListener reporterManager = new TestSetRunListener(reports, this.globalRunStatistics);
        if (this.first == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.first == null) {
                    this.first = reporterManager;
                    reporterManager.runStarting();
                }
            }
        }
        return reporterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunResult close() {
        this.consoleOutputCapture.restoreStreams();
        this.warnIfNoTests();
        Object object = this.lock;
        synchronized (object) {
            if (this.first != null) {
                this.first.runCompleted();
            }
            return this.globalRunStatistics.getRunResult();
        }
    }

    protected List instantiateReportsNewStyle(List reportDefinitions, ReporterConfiguration reporterConfiguration, ClassLoader classLoader) {
        ArrayList<Reporter> reports = new ArrayList<Reporter>();
        Iterator i = reportDefinitions.iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            Reporter report = ReporterManagerFactory.instantiateReportNewStyle(className, reporterConfiguration, classLoader);
            reports.add(report);
        }
        return reports;
    }

    private static Reporter instantiateReportNewStyle(String className, ReporterConfiguration params, ClassLoader classLoader) {
        Class clazz = ReflectionUtils.loadClass(classLoader, className);
        if (params != null) {
            Class[] paramTypes = new Class[]{ReflectionUtils.loadClass(classLoader, (class$org$apache$maven$surefire$report$ReporterConfiguration == null ? (class$org$apache$maven$surefire$report$ReporterConfiguration = ReporterManagerFactory.class$("org.apache.maven.surefire.report.ReporterConfiguration")) : class$org$apache$maven$surefire$report$ReporterConfiguration).getName())};
            Constructor constructor = ReflectionUtils.getConstructor(clazz, paramTypes);
            return (Reporter)ReflectionUtils.newInstance(constructor, new Object[]{params});
        }
        try {
            return (Reporter)clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SurefireReflectionException(e);
        }
        catch (InstantiationException e) {
            throw new SurefireReflectionException(e);
        }
    }

    public DirectConsoleReporter createConsoleReporter() {
        return new DefaultDirectConsoleReporter(this.reporterConfiguration.getOriginalSystemOut());
    }

    private void warnIfNoTests() {
        if (this.getGlobalRunStatistics().getRunResult().getCompletedCount() == 0) {
            List target = this.instantiateReportsNewStyle(this.reportDefinitions, this.reporterConfiguration, this.surefireClassLoader);
            new MulticastingReporter(target).writeMessage("There are no tests to run.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

