/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.testset;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TestRequest {
    private final List suiteXmlFiles;
    private final File testSourceDirectory;
    private final String requestedTest;

    public TestRequest(List suiteXmlFiles, File testSourceDirectory, String requestedTest) {
        this.suiteXmlFiles = TestRequest.createFiles(suiteXmlFiles);
        this.testSourceDirectory = testSourceDirectory;
        this.requestedTest = requestedTest;
    }

    public List getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public String getRequestedTest() {
        return this.requestedTest;
    }

    private static List createFiles(List suiteXmlFiles) {
        if (suiteXmlFiles != null) {
            ArrayList<File> files = new ArrayList<File>();
            for (int i = 0; i < suiteXmlFiles.size(); ++i) {
                Object element = suiteXmlFiles.get(i);
                files.add(element instanceof String ? new File((String)element) : (File)element);
            }
            return files;
        }
        return null;
    }
}

