/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.suite;

import java.util.List;
import org.apache.maven.surefire.suite.SurefireTestSuite;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;

public class SuiteDefinition {
    private final String suiteClassName;
    private final Object[] params;

    public SuiteDefinition(String suiteClassName, Object[] params) {
        this.suiteClassName = suiteClassName;
        this.params = params;
    }

    public SurefireTestSuite newInstance(ClassLoader surefireClassLoader) throws TestSetFailedException {
        return SuiteDefinition.instantiateSuite(this.suiteClassName, this.params, surefireClassLoader);
    }

    public static SuiteDefinition fromBooterFormat(List testSuiteDefinitions) {
        if (testSuiteDefinitions.size() != 1) {
            throw new IllegalStateException("No more than 1 SuiteDefinition supported");
        }
        Object[] item = (Object[])testSuiteDefinitions.get(0);
        String suiteClassName1 = (String)item[0];
        return new SuiteDefinition(suiteClassName1, (Object[])item[1]);
    }

    private static SurefireTestSuite instantiateSuite(String suiteClass, Object[] params, ClassLoader classLoader) {
        return (SurefireTestSuite)ReflectionUtils.instantiateObject(suiteClass, params, classLoader);
    }
}

