/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import org.apache.maven.surefire.report.StackTraceWriter;

public class ReportEntry {
    private final String source;
    private final String name;
    private final String group;
    private final String message;
    private final StackTraceWriter stackTraceWriter;
    private final Integer elapsed;

    protected ReportEntry(String name, String group) {
        this.name = name;
        this.group = group;
        this.stackTraceWriter = null;
        this.elapsed = null;
        this.message = null;
        this.source = null;
    }

    public ReportEntry(String source, String name, String message) {
        this(source, name, null, message, null, null);
    }

    public ReportEntry(String source, String name, String message, StackTraceWriter stackTraceWriter) {
        this(source, name, null, message, stackTraceWriter, null);
    }

    public ReportEntry(String source, String name, String group, String message, StackTraceWriter stackTraceWriter) {
        this(source, name, group, message, stackTraceWriter, null);
    }

    public ReportEntry(String source, String name, String group, String message, StackTraceWriter stackTraceWriter, Integer elapsed) {
        if (source == null) {
            throw new NullPointerException("source is null");
        }
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (message == null) {
            throw new NullPointerException("message is null");
        }
        this.source = source;
        this.name = name;
        this.group = group;
        this.message = message;
        this.stackTraceWriter = stackTraceWriter;
        this.elapsed = elapsed;
    }

    public String getSourceName() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public String getGroup() {
        return this.group;
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceWriter getStackTraceWriter() {
        return this.stackTraceWriter;
    }

    public Integer getElapsed() {
        return this.elapsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportEntry that = (ReportEntry)o;
        if (this.elapsed != null ? !this.elapsed.equals(that.elapsed) : that.elapsed != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        return !(this.stackTraceWriter != null ? !this.stackTraceWriter.equals(that.stackTraceWriter) : that.stackTraceWriter != null);
    }

    public int hashCode() {
        int result = this.source != null ? this.source.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.stackTraceWriter != null ? this.stackTraceWriter.hashCode() : 0);
        result = 31 * result + (this.elapsed != null ? this.elapsed.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ReportEntry{source='" + this.source + '\'' + ", name='" + this.name + '\'' + ", group='" + this.group + '\'' + ", message='" + this.message + '\'' + ", stackTraceWriter=" + this.stackTraceWriter + ", elapsed=" + this.elapsed + '}';
    }
}

