/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.RunStatistics;
import org.apache.maven.surefire.testset.TestSetFailedException;

public class ReporterManagerFactory {
    private final List reportDefinitions;
    private final ClassLoader surefireClassLoader;
    private final RunStatistics globalRunStatistics = new RunStatistics();
    private ReporterManager first;
    private final Object lock = new Object();
    static /* synthetic */ Class class$java$lang$String;

    public ReporterManagerFactory(List reportDefinitions, ClassLoader surefireClassLoader) {
        this.reportDefinitions = reportDefinitions;
        this.surefireClassLoader = surefireClassLoader;
    }

    public RunStatistics getGlobalRunStatistics() {
        return this.globalRunStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReporterManager createReporterManager() throws TestSetFailedException {
        List reports = this.instantiateReports(this.reportDefinitions, this.surefireClassLoader);
        ReporterManager reporterManager = new ReporterManager(reports, this.globalRunStatistics);
        if (this.first == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.first == null) {
                    this.first = reporterManager;
                    reporterManager.runStarting();
                }
            }
        }
        return reporterManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.first != null) {
                this.first.runCompleted();
            }
        }
    }

    private List instantiateReports(List reportDefinitions, ClassLoader classLoader) throws TestSetFailedException {
        ArrayList<Reporter> reports = new ArrayList<Reporter>();
        Iterator i = reportDefinitions.iterator();
        while (i.hasNext()) {
            Object[] definition = (Object[])i.next();
            String className = (String)definition[0];
            Object[] params = (Object[])definition[1];
            Reporter report = ReporterManagerFactory.instantiateReport(className, params, classLoader);
            reports.add(report);
        }
        return reports;
    }

    private static Reporter instantiateReport(String className, Object[] params, ClassLoader classLoader) throws TestSetFailedException {
        try {
            return (Reporter)ReporterManagerFactory.instantiateObject(className, params, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TestSetFailedException("Unable to find class to create report '" + className + "'", e);
        }
        catch (NoSuchMethodException e) {
            throw new TestSetFailedException("Unable to find appropriate constructor to create report: " + e.getMessage(), e);
        }
    }

    private static Object instantiateObject(String className, Object[] params, ClassLoader classLoader) throws TestSetFailedException, ClassNotFoundException, NoSuchMethodException {
        Object object;
        Class<?> clazz = classLoader.loadClass(className);
        try {
            if (params != null) {
                Class[] paramTypes = new Class[params.length];
                for (int j = 0; j < params.length; ++j) {
                    paramTypes[j] = params[j] == null ? (class$java$lang$String == null ? ReporterManagerFactory.class$("java.lang.String") : class$java$lang$String) : params[j].getClass();
                }
                Constructor<?> constructor = clazz.getConstructor(paramTypes);
                object = constructor.newInstance(params);
            } else {
                object = clazz.newInstance();
            }
        }
        catch (IllegalAccessException e) {
            throw new TestSetFailedException("Unable to instantiate object: " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new TestSetFailedException(e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (InstantiationException e) {
            throw new TestSetFailedException("Unable to instantiate object: " + e.getMessage(), e);
        }
        return object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

