/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.Reporter;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.util.TeeStream;
import org.codehaus.plexus.util.IOUtil;

public class ReporterManager {
    private int completedCount;
    private int errors;
    private Collection errorSources = new ArrayList();
    private int failures;
    private Collection failureSources = new ArrayList();
    private List reports;
    private PrintStream oldOut;
    private PrintStream oldErr;
    private PrintStream newErr;
    private PrintStream newOut;
    private int skipped;
    private static final String RESULTS_ERRORS = "errors";
    private static final String RESULTS_COMPLETED_COUNT = "completedCount";
    private static final String RESULTS_FAILURES = "failures";
    private static final String RESULTS_SKIPPED = "skipped";
    private ByteArrayOutputStream stdOut;
    private ByteArrayOutputStream stdErr;

    public ReporterManager(List reports) {
        this.reports = reports;
    }

    public void addReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException();
        }
        if (!this.reports.contains(reporter)) {
            this.reports.add(reporter);
        }
    }

    public void removeReport(Reporter report) {
        if (report == null) {
            throw new NullPointerException();
        }
        if (this.reports.contains(report)) {
            this.reports.remove(report);
        }
    }

    public List getReports() {
        return this.reports;
    }

    public void writeMessage(String message) {
        Iterator i = this.reports.iterator();
        while (i.hasNext()) {
            Reporter report = (Reporter)i.next();
            report.writeMessage(message);
        }
    }

    public void runStarting(int testCount) {
        if (testCount < 0) {
            throw new IllegalArgumentException("testCount is less than zero");
        }
        Iterator i = this.reports.iterator();
        while (i.hasNext()) {
            Reporter report = (Reporter)i.next();
            report.runStarting(testCount);
        }
    }

    public void runStopped() {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.runStopped();
        }
    }

    public void runAborted(ReportEntry report) {
        if (report == null) {
            throw new NullPointerException();
        }
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.runAborted(report);
        }
        ++this.errors;
    }

    public void runCompleted() {
        Iterator iterator;
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.runCompleted();
        }
        this.writeFooter("");
        this.writeFooter("Results :");
        this.writeFooter("");
        if (this.failures > 0) {
            this.writeFooter("Failed tests: ");
            iterator = this.failureSources.iterator();
            while (iterator.hasNext()) {
                this.writeFooter("  " + iterator.next());
            }
            this.writeFooter("");
        }
        if (this.errors > 0) {
            this.writeFooter("Tests in error: ");
            iterator = this.errorSources.iterator();
            while (iterator.hasNext()) {
                this.writeFooter("  " + iterator.next());
            }
            this.writeFooter("");
        }
        this.writeFooter("Tests run: " + this.completedCount + ", Failures: " + this.failures + ", Errors: " + this.errors + ", Skipped: " + this.skipped);
        this.writeFooter("");
    }

    private void writeFooter(String footer) {
        Iterator i = this.reports.iterator();
        while (i.hasNext()) {
            Reporter report = (Reporter)i.next();
            report.writeFooter(footer);
        }
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.testSetStarting(report);
        }
    }

    public void testSetCompleted(ReportEntry report) {
        if (!this.reports.isEmpty()) {
            Reporter reporter = (Reporter)this.reports.get(0);
            this.skipped += reporter.getNumSkipped();
            this.errors += reporter.getNumErrors();
            this.errorSources.addAll(reporter.getErrorSources());
            this.failures += reporter.getNumFailures();
            this.failureSources.addAll(reporter.getFailureSources());
            this.completedCount += reporter.getNumTests();
        }
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            try {
                reporter.testSetCompleted(report);
            }
            catch (Exception e) {}
        }
    }

    public void testSetAborted(ReportEntry report) {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.testSetAborted(report);
        }
        ++this.errors;
    }

    public void testStarting(ReportEntry report) {
        this.stdOut = new ByteArrayOutputStream();
        this.newOut = new PrintStream(this.stdOut);
        this.oldOut = System.out;
        TeeStream tee = new TeeStream(this.oldOut, this.newOut);
        System.setOut(tee);
        this.stdErr = new ByteArrayOutputStream();
        this.newErr = new PrintStream(this.stdErr);
        this.oldErr = System.err;
        tee = new TeeStream(this.oldErr, this.newErr);
        System.setErr(tee);
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.testStarting(report);
        }
    }

    public void testSucceeded(ReportEntry report) {
        this.resetStreams();
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.testSucceeded(report);
        }
    }

    public void testError(ReportEntry reportEntry) {
        this.testFailed(reportEntry, "error");
    }

    public void testFailed(ReportEntry reportEntry) {
        this.testFailed(reportEntry, "failure");
    }

    private void testFailed(ReportEntry reportEntry, String typeError) {
        String stdOutLog = this.stdOut != null ? this.stdOut.toString() : "";
        String stdErrLog = this.stdErr != null ? this.stdErr.toString() : "";
        this.resetStreams();
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            if ("failure".equals(typeError)) {
                reporter.testFailed(reportEntry, stdOutLog, stdErrLog);
                continue;
            }
            reporter.testError(reportEntry, stdOutLog, stdErrLog);
        }
    }

    private void resetStreams() {
        if (this.oldOut != null) {
            System.setOut(this.oldOut);
        }
        if (this.oldErr != null) {
            System.setErr(this.oldErr);
        }
        IOUtil.close((OutputStream)this.newOut);
        IOUtil.close((OutputStream)this.newErr);
    }

    public void reset() {
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter report = (Reporter)it.next();
            report.reset();
        }
    }

    public int getNumErrors() {
        return this.errors;
    }

    public int getNumFailures() {
        return this.failures;
    }

    public int getNbTests() {
        return this.completedCount;
    }

    public void testSkipped(ReportEntry report) {
        this.resetStreams();
        Iterator it = this.reports.iterator();
        while (it.hasNext()) {
            Reporter reporter = (Reporter)it.next();
            reporter.testSkipped(report);
        }
    }

    public void initResultsFromProperties(Properties results) {
        this.errors = Integer.valueOf(results.getProperty(RESULTS_ERRORS, "0"));
        this.skipped = Integer.valueOf(results.getProperty(RESULTS_SKIPPED, "0"));
        this.failures = Integer.valueOf(results.getProperty(RESULTS_FAILURES, "0"));
        this.completedCount = Integer.valueOf(results.getProperty(RESULTS_COMPLETED_COUNT, "0"));
    }

    public void updateResultsProperties(Properties results) {
        results.setProperty(RESULTS_ERRORS, String.valueOf(this.errors));
        results.setProperty(RESULTS_COMPLETED_COUNT, String.valueOf(this.completedCount));
        results.setProperty(RESULTS_FAILURES, String.valueOf(this.failures));
        results.setProperty(RESULTS_SKIPPED, String.valueOf(this.skipped));
    }
}

