/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.scriptinterpreter;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.PrintStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.maven.shared.scriptinterpreter.ScriptEvaluationException;
import org.apache.maven.shared.scriptinterpreter.ScriptInterpreter;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.tools.RootLoader;

class GroovyScriptInterpreter
implements ScriptInterpreter {
    GroovyScriptInterpreter() {
    }

    @Override
    public Object evaluateScript(String script, List<String> classPath, Map<String, ? extends Object> globalVariables, PrintStream scriptOutput) throws ScriptEvaluationException {
        PrintStream origOut = System.out;
        PrintStream origErr = System.err;
        try {
            Object object;
            RootLoader childFirstLoader = new RootLoader(new URL[0], this.getClass().getClassLoader());
            try {
                if (scriptOutput != null) {
                    System.setErr(scriptOutput);
                    System.setOut(scriptOutput);
                }
                if (classPath != null && !classPath.isEmpty()) {
                    for (String path : classPath) {
                        childFirstLoader.addURL(new File(path).toURI().toURL());
                    }
                }
                GroovyShell interpreter = new GroovyShell((ClassLoader)childFirstLoader, new Binding(globalVariables), new CompilerConfiguration(CompilerConfiguration.DEFAULT));
                object = interpreter.evaluate(script);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        childFirstLoader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new ScriptEvaluationException(e);
                }
            }
            childFirstLoader.close();
            return object;
        }
        finally {
            System.setErr(origErr);
            System.setOut(origOut);
        }
    }
}

