/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.filter;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.filter.RemoteRepositoryFilterSourceSupport;
import org.eclipse.aether.internal.impl.filter.ruletree.GroupTree;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.spi.io.PathProcessor;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;
import org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import org.eclipse.aether.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="groupId")
public final class GroupIdRemoteRepositoryFilterSource
extends RemoteRepositoryFilterSourceSupport
implements ArtifactResolverPostProcessor {
    public static final String NAME = "groupId";
    public static final String CONFIG_PROP_ENABLED = "aether.remoteRepositoryFilter.groupId";
    public static final boolean DEFAULT_ENABLED = true;
    public static final String CONFIG_PROP_SKIPPED = "aether.remoteRepositoryFilter.groupId.skipped";
    public static final boolean DEFAULT_SKIPPED = false;
    public static final String CONFIG_PROP_NO_INPUT_OUTCOME = "aether.remoteRepositoryFilter.groupId.noInputOutcome";
    public static final boolean DEFAULT_NO_INPUT_OUTCOME = true;
    public static final String CONFIG_PROP_BASEDIR = "aether.remoteRepositoryFilter.groupId.basedir";
    public static final String LOCAL_REPO_PREFIX_DIR = ".remoteRepositoryFilters";
    public static final String CONFIG_PROP_RECORD = "aether.remoteRepositoryFilter.groupId.record";
    static final String GROUP_ID_FILE_PREFIX = "groupId-";
    static final String GROUP_ID_FILE_SUFFIX = ".txt";
    private final Logger logger = LoggerFactory.getLogger(GroupIdRemoteRepositoryFilterSource.class);
    private final RepositorySystemLifecycle repositorySystemLifecycle;
    private final PathProcessor pathProcessor;
    private static final GroupTree DISABLED = GroupTree.create("disabled");
    private static final GroupTree ENABLED_NO_INPUT = GroupTree.create("enabled-no-input");

    @Inject
    public GroupIdRemoteRepositoryFilterSource(RepositoryKeyFunctionFactory repositoryKeyFunctionFactory, RepositorySystemLifecycle repositorySystemLifecycle, PathProcessor pathProcessor) {
        super(repositoryKeyFunctionFactory);
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle);
        this.pathProcessor = Objects.requireNonNull(pathProcessor);
    }

    private ConcurrentMap<RemoteRepository, GroupTree> rules(RepositorySystemSession session) {
        return (ConcurrentMap)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".rules"), ConcurrentHashMap::new);
    }

    private ConcurrentMap<RemoteRepository, Path> ruleFiles(RepositorySystemSession session) {
        return (ConcurrentMap)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".ruleFiles"), ConcurrentHashMap::new);
    }

    private ConcurrentMap<RemoteRepository, Set<String>> recordedRules(RepositorySystemSession session) {
        return (ConcurrentMap)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".recordedRules"), ConcurrentHashMap::new);
    }

    private AtomicBoolean onShutdownHandlerRegistered(RepositorySystemSession session) {
        return (AtomicBoolean)session.getData().computeIfAbsent((Object)(this.getClass().getName() + ".onShutdownHandlerRegistered"), AtomicBoolean::new);
    }

    @Override
    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{CONFIG_PROP_ENABLED}) && !ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_SKIPPED});
    }

    private boolean isRepositoryFilteringEnabled(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (this.isEnabled(session)) {
            return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.groupId." + remoteRepository.getId(), "aether.remoteRepositoryFilter.groupId.*"}) && !ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{"aether.remoteRepositoryFilter.groupId.skipped." + remoteRepository.getId(), "aether.remoteRepositoryFilter.groupId.skipped.*"});
        }
        return false;
    }

    public RemoteRepositoryFilter getRemoteRepositoryFilter(RepositorySystemSession session) {
        if (this.isEnabled(session) && !this.isRecord(session)) {
            return new GroupIdFilter(session);
        }
        return null;
    }

    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        if (this.isEnabled(session) && this.isRecord(session)) {
            if (this.onShutdownHandlerRegistered(session).compareAndSet(false, true)) {
                this.repositorySystemLifecycle.addOnSystemEndedHandler(() -> this.saveRecordedLines(session));
            }
            for (ArtifactResult artifactResult : artifactResults) {
                RemoteRepository remoteRepository;
                if (!artifactResult.isResolved() || !(artifactResult.getRepository() instanceof RemoteRepository) || !this.isRepositoryFilteringEnabled(session, remoteRepository = (RemoteRepository)artifactResult.getRepository())) continue;
                this.ruleFile(session, remoteRepository);
                String line = "=" + artifactResult.getArtifact().getGroupId();
                RemoteRepository normalized = this.normalizeRemoteRepository(session, remoteRepository);
                this.recordedRules(session).computeIfAbsent(normalized, k -> new TreeSet()).add(line);
                this.rules(session).compute(normalized, (k, v) -> {
                    if (v == null || v == DISABLED || v == ENABLED_NO_INPUT) {
                        v = GroupTree.create("record");
                    }
                    return v;
                }).loadNode(line);
            }
        }
    }

    private Path ruleFile(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.ruleFiles(session).computeIfAbsent(this.normalizeRemoteRepository(session, remoteRepository), r -> this.getBasedir(session, LOCAL_REPO_PREFIX_DIR, CONFIG_PROP_BASEDIR, false).resolve(GROUP_ID_FILE_PREFIX + this.repositoryKey(session, remoteRepository) + GROUP_ID_FILE_SUFFIX));
    }

    private GroupTree cacheRules(RepositorySystemSession session, RemoteRepository remoteRepository) {
        return this.rules(session).computeIfAbsent(this.normalizeRemoteRepository(session, remoteRepository), r -> this.loadRepositoryRules(session, (RemoteRepository)r));
    }

    private GroupTree loadRepositoryRules(RepositorySystemSession session, RemoteRepository remoteRepository) {
        if (this.isRepositoryFilteringEnabled(session, remoteRepository)) {
            Path filePath = this.ruleFile(session, remoteRepository);
            if (Files.isReadable(filePath)) {
                GroupTree groupTree;
                block11: {
                    Stream<String> lines = Files.lines(filePath, StandardCharsets.UTF_8);
                    try {
                        GroupTree groupTree2 = GroupTree.create(filePath.getFileName().toString());
                        int rules = groupTree2.loadNodes(lines);
                        this.logger.info("Loaded {} group rules for remote repository {}", (Object)rules, (Object)remoteRepository.getId());
                        if (this.logger.isDebugEnabled()) {
                            groupTree2.dump("");
                        }
                        groupTree = groupTree2;
                        if (lines == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (lines != null) {
                                try {
                                    lines.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    lines.close();
                }
                return groupTree;
            }
            this.logger.debug("Group rules file for remote repository {} not available", (Object)remoteRepository);
            return ENABLED_NO_INPUT;
        }
        this.logger.debug("Group rules file for remote repository {} disabled", (Object)remoteRepository);
        return DISABLED;
    }

    private boolean isRecord(RepositorySystemSession session) {
        return ConfigUtils.getBoolean((RepositorySystemSession)session, (boolean)false, (String[])new String[]{CONFIG_PROP_RECORD});
    }

    private void saveRecordedLines(RepositorySystemSession session) {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Map.Entry entry : this.ruleFiles(session).entrySet()) {
            Set recorded = (Set)this.recordedRules(session).get(entry.getKey());
            if (recorded == null || recorded.isEmpty()) continue;
            try {
                ArrayList<String> result = new ArrayList<String>();
                if (Files.isReadable((Path)entry.getValue())) {
                    result.addAll(Files.readAllLines((Path)entry.getValue()));
                }
                result.add("# Recorded entries");
                result.addAll(recorded);
                this.logger.info("Saving {} groupIds to '{}'", (Object)result.size(), entry.getValue());
                this.pathProcessor.writeWithBackup((Path)entry.getValue(), result.stream().collect(Collectors.joining(System.lineSeparator())));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow((String)"session save groupIds failure", exceptions);
    }

    private class GroupIdFilter
    implements RemoteRepositoryFilter {
        private final RepositorySystemSession session;

        private GroupIdFilter(RepositorySystemSession session) {
            this.session = session;
        }

        public RemoteRepositoryFilter.Result acceptArtifact(RemoteRepository repository, Artifact artifact) {
            return this.acceptGroupId(repository, artifact.getGroupId());
        }

        public RemoteRepositoryFilter.Result acceptMetadata(RemoteRepository repository, Metadata metadata) {
            return this.acceptGroupId(repository, metadata.getGroupId());
        }

        private RemoteRepositoryFilter.Result acceptGroupId(RemoteRepository repository, String groupId) {
            boolean accepted;
            GroupTree groupTree = GroupIdRemoteRepositoryFilterSource.this.cacheRules(this.session, repository);
            if (groupTree == DISABLED) {
                return RemoteRepositoryFilterSourceSupport.result(true, GroupIdRemoteRepositoryFilterSource.NAME, "Disabled");
            }
            if (groupTree == ENABLED_NO_INPUT) {
                return RemoteRepositoryFilterSourceSupport.result(ConfigUtils.getBoolean((RepositorySystemSession)this.session, (boolean)true, (String[])new String[]{"aether.remoteRepositoryFilter.groupId.noInputOutcome." + repository.getId(), GroupIdRemoteRepositoryFilterSource.CONFIG_PROP_NO_INPUT_OUTCOME}), GroupIdRemoteRepositoryFilterSource.NAME, "No input available");
            }
            return RemoteRepositoryFilterSourceSupport.result(accepted, GroupIdRemoteRepositoryFilterSource.NAME, (accepted = groupTree.acceptedGroupId(groupId)) ? "G:" + groupId + " allowed from " + repository.getId() : "G:" + groupId + " NOT allowed from " + repository.getId());
        }
    }
}

