/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposer;
import org.eclipse.aether.internal.impl.LocalPathPrefixComposerFactorySupport;
import org.eclipse.aether.repository.RepositoryKeyFunction;
import org.eclipse.aether.spi.remoterepo.RepositoryKeyFunctionFactory;

@Singleton
@Named
public final class DefaultLocalPathPrefixComposerFactory
extends LocalPathPrefixComposerFactorySupport {
    private final RepositoryKeyFunctionFactory repositoryKeyFunctionFactory;

    @Inject
    public DefaultLocalPathPrefixComposerFactory(RepositoryKeyFunctionFactory repositoryKeyFunctionFactory) {
        this.repositoryKeyFunctionFactory = Objects.requireNonNull(repositoryKeyFunctionFactory);
    }

    @Override
    public LocalPathPrefixComposer createComposer(RepositorySystemSession session) {
        return new DefaultLocalPathPrefixComposer(this.isSplit(session), this.getLocalPrefix(session), this.isSplitLocal(session), this.getRemotePrefix(session), this.isSplitRemote(session), this.isSplitRemoteRepository(session), this.isSplitRemoteRepositoryLast(session), this.getReleasesPrefix(session), this.getSnapshotsPrefix(session), this.repositoryKeyFunctionFactory.systemRepositoryKeyFunction(session));
    }

    private static class DefaultLocalPathPrefixComposer
    extends LocalPathPrefixComposerFactorySupport.LocalPathPrefixComposerSupport {
        private DefaultLocalPathPrefixComposer(boolean split, String localPrefix, boolean splitLocal, String remotePrefix, boolean splitRemote, boolean splitRemoteRepository, boolean splitRemoteRepositoryLast, String releasesPrefix, String snapshotsPrefix, RepositoryKeyFunction repositoryKeyFunction) {
            super(split, localPrefix, splitLocal, remotePrefix, splitRemote, splitRemoteRepository, splitRemoteRepositoryLast, releasesPrefix, snapshotsPrefix, repositoryKeyFunction);
        }
    }
}

