/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.impl.RemoteRepositoryFilterManager;
import org.eclipse.aether.impl.RepositoryConnectorProvider;
import org.eclipse.aether.internal.impl.PrioritizedComponent;
import org.eclipse.aether.internal.impl.PrioritizedComponents;
import org.eclipse.aether.internal.impl.Utils;
import org.eclipse.aether.internal.impl.filter.FilteringRepositoryConnector;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.filter.RemoteRepositoryFilter;
import org.eclipse.aether.transfer.NoRepositoryConnectorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultRepositoryConnectorProvider
implements RepositoryConnectorProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRepositoryConnectorProvider.class);
    private final Map<String, RepositoryConnectorFactory> connectorFactories;
    private final RemoteRepositoryFilterManager remoteRepositoryFilterManager;

    @Inject
    public DefaultRepositoryConnectorProvider(Map<String, RepositoryConnectorFactory> connectorFactories, RemoteRepositoryFilterManager remoteRepositoryFilterManager) {
        this.connectorFactories = Collections.unmodifiableMap(connectorFactories);
        this.remoteRepositoryFilterManager = Objects.requireNonNull(remoteRepositoryFilterManager);
    }

    @Override
    public RepositoryConnector newRepositoryConnector(RepositorySystemSession session, RemoteRepository repository) throws NoRepositoryConnectorException {
        Objects.requireNonNull(repository, "remote repository cannot be null");
        if (repository.isBlocked()) {
            if (repository.getMirroredRepositories().isEmpty()) {
                throw new NoRepositoryConnectorException(repository, "Blocked repository: " + repository);
            }
            throw new NoRepositoryConnectorException(repository, "Blocked mirror for repositories: " + repository.getMirroredRepositories());
        }
        PrioritizedComponents<RepositoryConnectorFactory> factories = PrioritizedComponents.reuseOrCreate(session, this.connectorFactories, RepositoryConnectorFactory::getPriority);
        RemoteRepositoryFilter filter = this.remoteRepositoryFilterManager.getRemoteRepositoryFilter(session);
        ArrayList<NoRepositoryConnectorException> errors = new ArrayList<NoRepositoryConnectorException>();
        for (PrioritizedComponent<RepositoryConnectorFactory> prioritizedComponent : factories.getEnabled()) {
            try {
                RepositoryConnector connector = prioritizedComponent.getComponent().newInstance(session, repository);
                if (LOGGER.isDebugEnabled()) {
                    Proxy proxy;
                    StringBuilder buffer = new StringBuilder(256);
                    buffer.append("Using connector ").append(connector.getClass().getSimpleName());
                    Utils.appendClassLoader(buffer, connector);
                    buffer.append(" with priority ").append(prioritizedComponent.getPriority());
                    buffer.append(" for ").append(repository.getUrl());
                    Authentication auth = repository.getAuthentication();
                    if (auth != null) {
                        buffer.append(" with ").append(auth);
                    }
                    if ((proxy = repository.getProxy()) != null) {
                        buffer.append(" via ").append(proxy.getHost()).append(':').append(proxy.getPort());
                        auth = proxy.getAuthentication();
                        if (auth != null) {
                            buffer.append(" with ").append(auth);
                        }
                    }
                    LOGGER.debug(buffer.toString());
                }
                if (filter != null) {
                    return new FilteringRepositoryConnector(repository, connector, filter);
                }
                return connector;
            }
            catch (NoRepositoryConnectorException e) {
                errors.add(e);
            }
        }
        if (LOGGER.isDebugEnabled() && errors.size() > 1) {
            for (Exception exception : errors) {
                LOGGER.debug("Could not obtain connector factory for {}", (Object)repository, (Object)exception);
            }
        }
        StringBuilder buffer = new StringBuilder(256);
        if (factories.isEmpty()) {
            buffer.append("No connector factories available");
        } else {
            buffer.append("Cannot access ").append(repository.getUrl());
            buffer.append(" with type ").append(repository.getContentType());
            buffer.append(" using the available connector factories: ");
            factories.list(buffer);
        }
        throw new NoRepositoryConnectorException(repository, buffer.toString(), errors.size() == 1 ? (Throwable)errors.get(0) : null);
    }
}

