/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.util.ChecksumUtils;
import org.eclipse.aether.util.FileUtils;

@Singleton
@Named
public class DefaultFileProcessor
implements FileProcessor {
    public boolean mkdirs(File directory) {
        File canonDir;
        if (directory == null) {
            return false;
        }
        if (directory.exists()) {
            return false;
        }
        if (directory.mkdir()) {
            return true;
        }
        try {
            canonDir = directory.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        File parentDir = canonDir.getParentFile();
        return parentDir != null && (this.mkdirs(parentDir) || parentDir.exists()) && canonDir.mkdir();
    }

    public void write(File target, String data) throws IOException {
        FileUtils.writeFile((Path)target.toPath(), p -> Files.write(p, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]));
    }

    public void write(File target, InputStream source) throws IOException {
        FileUtils.writeFile((Path)target.toPath(), p -> Files.copy(source, p, new CopyOption[0]));
    }

    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    /*
     * Exception decompiling
     */
    public long copy(File source, File target, FileProcessor.ProgressListener listener) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long copy(OutputStream os, InputStream is, FileProcessor.ProgressListener listener) throws IOException {
        int bytes;
        long total = 0L;
        byte[] buffer = new byte[32768];
        while ((bytes = is.read(buffer)) >= 0) {
            os.write(buffer, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                listener.progressed(ByteBuffer.wrap(buffer, 0, bytes));
            }
            catch (Exception exception) {}
        }
        return total;
    }

    public void move(File source, File target) throws IOException {
        if (!source.renameTo(target)) {
            this.copy(source, target);
            target.setLastModified(source.lastModified());
            source.delete();
        }
    }

    public String readChecksum(File checksumFile) throws IOException {
        return ChecksumUtils.read((File)checksumFile);
    }

    public void writeChecksum(File checksumFile, String checksum) throws IOException {
        this.write(checksumFile, checksum);
    }
}

