/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.synccontext.named;

import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.internal.impl.synccontext.named.NameMapper;
import org.eclipse.aether.internal.impl.synccontext.named.NamedLockFactorySelector;
import org.eclipse.aether.internal.impl.synccontext.named.providers.DiscriminatingNameMapperProvider;
import org.eclipse.aether.internal.impl.synccontext.named.providers.FileGAVNameMapperProvider;
import org.eclipse.aether.internal.impl.synccontext.named.providers.FileHashingGAVNameMapperProvider;
import org.eclipse.aether.internal.impl.synccontext.named.providers.GAVNameMapperProvider;
import org.eclipse.aether.internal.impl.synccontext.named.providers.StaticNameMapperProvider;
import org.eclipse.aether.named.NamedLockFactory;
import org.eclipse.aether.named.providers.FileLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalReadWriteLockNamedLockFactory;
import org.eclipse.aether.named.providers.LocalSemaphoreNamedLockFactory;
import org.eclipse.aether.named.providers.NoopNamedLockFactory;

@Singleton
@Named
public final class ParameterizedNamedLockFactorySelector
implements NamedLockFactorySelector {
    private static final String FACTORY_KEY = "aether.syncContext.named.factory";
    private static final String NAME_MAPPER_KEY = "aether.syncContext.named.nameMapper";
    private static final Map<String, NamedLockFactory> FACTORIES;
    private static final String DEFAULT_FACTORY = "rwlock-local";
    private static final Map<String, NameMapper> NAME_MAPPERS;
    private static final String DEFAULT_NAME_MAPPER = "gav";
    private final NamedLockFactory namedLockFactory;
    private final NameMapper nameMapper;

    public ParameterizedNamedLockFactorySelector() {
        this(FACTORIES, DEFAULT_FACTORY, NAME_MAPPERS, DEFAULT_NAME_MAPPER);
    }

    @Inject
    public ParameterizedNamedLockFactorySelector(Map<String, NamedLockFactory> factories, @Named(value="${aether.syncContext.named.factory:-rwlock-local}") String selectedFactoryName, Map<String, NameMapper> nameMappers, @Named(value="${aether.syncContext.named.nameMapper:-gav}") String selectedMapperName) {
        this.namedLockFactory = ParameterizedNamedLockFactorySelector.selectNamedLockFactory(factories, selectedFactoryName);
        this.nameMapper = ParameterizedNamedLockFactorySelector.selectNameMapper(nameMappers, selectedMapperName);
    }

    @Override
    public NamedLockFactory getSelectedNamedLockFactory() {
        return this.namedLockFactory;
    }

    @Override
    public NameMapper getSelectedNameMapper() {
        return this.nameMapper;
    }

    private static NamedLockFactory selectNamedLockFactory(Map<String, NamedLockFactory> factories, String factoryName) {
        NamedLockFactory factory = factories.get(factoryName);
        if (factory == null) {
            throw new IllegalArgumentException("Unknown NamedLockFactory name: " + factoryName + ", known ones: " + factories.keySet());
        }
        return factory;
    }

    private static NameMapper selectNameMapper(Map<String, NameMapper> nameMappers, String nameMapperName) {
        NameMapper nameMapper = nameMappers.get(nameMapperName);
        if (nameMapper == null) {
            throw new IllegalArgumentException("Unknown NameMapper name: " + nameMapperName + ", known ones: " + nameMappers.keySet());
        }
        return nameMapper;
    }

    static {
        HashMap<String, NamedLockFactory> factories = new HashMap<String, NamedLockFactory>();
        factories.put("noop", (NamedLockFactory)new NoopNamedLockFactory());
        factories.put(DEFAULT_FACTORY, (NamedLockFactory)new LocalReadWriteLockNamedLockFactory());
        factories.put("semaphore-local", (NamedLockFactory)new LocalSemaphoreNamedLockFactory());
        factories.put("file-lock", (NamedLockFactory)new FileLockNamedLockFactory());
        FACTORIES = factories;
        HashMap<String, NameMapper> mappers = new HashMap<String, NameMapper>();
        mappers.put("static", new StaticNameMapperProvider().get());
        mappers.put(DEFAULT_NAME_MAPPER, new GAVNameMapperProvider().get());
        mappers.put("discriminating", new DiscriminatingNameMapperProvider().get());
        mappers.put("file-gav", new FileGAVNameMapperProvider().get());
        mappers.put("file-hgav", new FileHashingGAVNameMapperProvider().get());
        NAME_MAPPERS = mappers;
    }
}

