/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.checksum;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.MultiRuntimeException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.RepositorySystemLifecycle;
import org.eclipse.aether.internal.impl.LocalPathComposer;
import org.eclipse.aether.internal.impl.checksum.FileTrustedChecksumsSourceSupport;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.spi.checksums.TrustedChecksumsSource;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="summaryFile")
public final class SummaryFileTrustedChecksumsSource
extends FileTrustedChecksumsSourceSupport {
    public static final String NAME = "summaryFile";
    private static final String CHECKSUMS_FILE_PREFIX = "checksums";
    private static final Logger LOGGER = LoggerFactory.getLogger(SummaryFileTrustedChecksumsSource.class);
    private final LocalPathComposer localPathComposer;
    private final RepositorySystemLifecycle repositorySystemLifecycle;
    private final ConcurrentHashMap<Path, ConcurrentHashMap<String, String>> checksums;
    private final ConcurrentHashMap<Path, Boolean> changedChecksums;
    private final AtomicBoolean onShutdownHandlerRegistered;

    @Inject
    public SummaryFileTrustedChecksumsSource(LocalPathComposer localPathComposer, RepositorySystemLifecycle repositorySystemLifecycle) {
        super(NAME);
        this.localPathComposer = Objects.requireNonNull(localPathComposer);
        this.repositorySystemLifecycle = Objects.requireNonNull(repositorySystemLifecycle);
        this.checksums = new ConcurrentHashMap();
        this.changedChecksums = new ConcurrentHashMap();
        this.onShutdownHandlerRegistered = new AtomicBoolean(false);
    }

    @Override
    protected Map<String, String> doGetTrustedArtifactChecksums(RepositorySystemSession session, Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories) {
        HashMap<String, String> result = new HashMap<String, String>();
        Path basedir = this.getBasedir(session, false);
        if (Files.isDirectory(basedir, new LinkOption[0])) {
            String artifactPath = this.localPathComposer.getPathForArtifact(artifact, false);
            boolean originAware = this.isOriginAware(session);
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                Path summaryFile = this.summaryFile(basedir, originAware, artifactRepository.getId(), checksumAlgorithmFactory.getFileExtension());
                ConcurrentHashMap algorithmChecksums = this.checksums.computeIfAbsent(summaryFile, f -> {
                    ConcurrentHashMap<String, String> loaded = this.loadProvidedChecksums(summaryFile);
                    if (Files.isRegularFile(summaryFile, new LinkOption[0])) {
                        LOGGER.info("Loaded {} {} trusted checksums for remote repository {}", new Object[]{loaded.size(), checksumAlgorithmFactory.getName(), artifactRepository.getId()});
                    }
                    return loaded;
                });
                String checksum = (String)algorithmChecksums.get(artifactPath);
                if (checksum == null) continue;
                result.put(checksumAlgorithmFactory.getName(), checksum);
            }
        }
        return result;
    }

    @Override
    protected SummaryFileWriter doGetTrustedArtifactChecksumsWriter(RepositorySystemSession session) {
        if (this.onShutdownHandlerRegistered.compareAndSet(false, true)) {
            this.repositorySystemLifecycle.addOnSystemEndedHandler(this::saveRecordedLines);
        }
        return new SummaryFileWriter(this.checksums, this.getBasedir(session, true), this.isOriginAware(session));
    }

    private Path summaryFile(Path basedir, boolean originAware, String repositoryId, String checksumExtension) {
        String fileName = CHECKSUMS_FILE_PREFIX;
        if (originAware) {
            fileName = fileName + "-" + repositoryId;
        }
        return basedir.resolve(fileName + "." + checksumExtension);
    }

    private ConcurrentHashMap<String, String> loadProvidedChecksums(Path summaryFile) {
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        if (Files.isRegularFile(summaryFile, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(summaryFile, StandardCharsets.UTF_8);){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.isEmpty()) continue;
                    String[] parts = line.split("  ", 2);
                    if (parts.length == 2) {
                        String artifactPath = parts[1];
                        String newChecksum = parts[0];
                        String oldChecksum = result.put(artifactPath, newChecksum);
                        if (oldChecksum == null) continue;
                        if (Objects.equals(oldChecksum, newChecksum)) {
                            LOGGER.warn("Checksums file '{}' contains duplicate checksums for artifact {}: {}", new Object[]{summaryFile, artifactPath, oldChecksum});
                            continue;
                        }
                        LOGGER.warn("Checksums file '{}' contains different checksums for artifact {}: old '{}' replaced by new '{}'", new Object[]{summaryFile, artifactPath, oldChecksum, newChecksum});
                        continue;
                    }
                    LOGGER.warn("Checksums file '{}' ignored malformed line '{}'", (Object)summaryFile, (Object)line);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return result;
    }

    private void saveRecordedLines() {
        if (this.changedChecksums.isEmpty()) {
            return;
        }
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Map.Entry<Path, ConcurrentHashMap<String, String>> entry : this.checksums.entrySet()) {
            ConcurrentHashMap<String, String> recordedLines;
            Path summaryFile = entry.getKey();
            if (this.changedChecksums.get(summaryFile) != Boolean.TRUE || (recordedLines = entry.getValue()).isEmpty()) continue;
            try {
                ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
                result.putAll(this.loadProvidedChecksums(summaryFile));
                result.putAll(recordedLines);
                LOGGER.info("Saving {} checksums to '{}'", (Object)result.size(), (Object)summaryFile);
                FileUtils.writeFileWithBackup((Path)summaryFile, p -> Files.write(p, (Iterable<? extends CharSequence>)result.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(e -> (String)e.getValue() + "  " + (String)e.getKey()).collect(Collectors.toList()), new OpenOption[0]));
            }
            catch (IOException e) {
                exceptions.add(e);
            }
        }
        MultiRuntimeException.mayThrow((String)"session save checksums failure", exceptions);
    }

    private class SummaryFileWriter
    implements TrustedChecksumsSource.Writer {
        private final ConcurrentHashMap<Path, ConcurrentHashMap<String, String>> cache;
        private final Path basedir;
        private final boolean originAware;

        private SummaryFileWriter(ConcurrentHashMap<Path, ConcurrentHashMap<String, String>> cache, Path basedir, boolean originAware) {
            this.cache = cache;
            this.basedir = basedir;
            this.originAware = originAware;
        }

        public void addTrustedArtifactChecksums(Artifact artifact, ArtifactRepository artifactRepository, List<ChecksumAlgorithmFactory> checksumAlgorithmFactories, Map<String, String> trustedArtifactChecksums) {
            String artifactPath = SummaryFileTrustedChecksumsSource.this.localPathComposer.getPathForArtifact(artifact, false);
            for (ChecksumAlgorithmFactory checksumAlgorithmFactory : checksumAlgorithmFactories) {
                Path summaryFile = SummaryFileTrustedChecksumsSource.this.summaryFile(this.basedir, this.originAware, artifactRepository.getId(), checksumAlgorithmFactory.getFileExtension());
                String checksum = Objects.requireNonNull(trustedArtifactChecksums.get(checksumAlgorithmFactory.getName()));
                String oldChecksum = this.cache.computeIfAbsent(summaryFile, k -> SummaryFileTrustedChecksumsSource.this.loadProvidedChecksums(summaryFile)).put(artifactPath, checksum);
                if (oldChecksum == null) {
                    SummaryFileTrustedChecksumsSource.this.changedChecksums.put(summaryFile, Boolean.TRUE);
                    continue;
                }
                if (Objects.equals(oldChecksum, checksum)) continue;
                SummaryFileTrustedChecksumsSource.this.changedChecksums.put(summaryFile, Boolean.TRUE);
                LOGGER.info("Trusted checksum for artifact {} replaced: old {}, new {}", new Object[]{artifact, oldChecksum, checksum});
            }
        }
    }
}

