/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.pmd.exec.PmdExecutor;
import org.apache.maven.plugins.pmd.exec.PmdRequest;
import org.apache.maven.plugins.pmd.exec.PmdResult;
import org.apache.maven.plugins.pmd.exec.ServiceExecutor;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.ToolchainManager;

@Named
@Singleton
public class PmdServiceExecutor
extends ServiceExecutor {
    @Inject
    public PmdServiceExecutor(ToolchainManager toolchainManager, Provider<MavenSession> sessionProvider) {
        super(toolchainManager, sessionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PmdResult execute(PmdRequest request) throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(PmdExecutor.class.getClassLoader());
            PmdExecutor executor = new PmdExecutor(request);
            String javaExecutable = this.getJavaExecutable(request.getJdkToolchain());
            if (javaExecutable != null) {
                PmdResult pmdResult = executor.fork(javaExecutable);
                return pmdResult;
            }
            PmdResult pmdResult = executor.run();
            return pmdResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }
}

