/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.pmd.AbstractPmdReport;
import org.apache.maven.plugins.pmd.CpdReportRenderer;
import org.apache.maven.plugins.pmd.exec.CpdExecutor;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.plugins.pmd.exec.CpdResult;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.i18n.I18N;

@Mojo(name="cpd", threadSafe=true)
public class CpdReport
extends AbstractPmdReport {
    @Parameter(defaultValue="java")
    private String language;
    @Parameter(property="minimumTokens", defaultValue="100")
    private int minimumTokens;
    @Parameter(property="cpd.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="cpd.ignoreLiterals", defaultValue="false")
    private boolean ignoreLiterals;
    @Parameter(property="cpd.ignoreIdentifiers", defaultValue="false")
    private boolean ignoreIdentifiers;
    @Parameter(property="cpd.ignoreAnnotations", defaultValue="false")
    private boolean ignoreAnnotations;
    @Component
    private I18N i18n;
    private CpdResult cpdResult;

    public String getName(Locale locale) {
        return this.getI18nString(locale, "name");
    }

    public String getDescription(Locale locale) {
        return this.getI18nString(locale, "description");
    }

    protected String getI18nString(Locale locale, String key) {
        return this.i18n.getString("cpd-report", locale, "report.cpd." + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeReport(Locale locale) throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            CpdReportRenderer r = new CpdReportRenderer(this.getSink(), this.i18n, locale, this.filesToProcess, this.cpdResult.getDuplications(), this.isAggregator());
            r.render();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }

    @Override
    public boolean canGenerateReport() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping CPD execution");
            return false;
        }
        boolean result = super.canGenerateReport();
        if (result) {
            try {
                this.executeCpd();
                if (this.skipEmptyReport && !(result = this.cpdResult.hasDuplications())) {
                    this.getLog().debug((CharSequence)"Skipping report since skipEmptyReport is true and there are no CPD issues.");
                }
            }
            catch (MavenReportException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private void executeCpd() throws MavenReportException {
        if (this.cpdResult != null) {
            this.getLog().debug((CharSequence)"CPD has already been run - skipping redundant execution.");
            return;
        }
        try {
            this.filesToProcess = this.getFilesToProcess();
            CpdRequest request = new CpdRequest();
            request.setMinimumTokens(this.minimumTokens);
            request.setLanguage(this.language);
            request.setIgnoreAnnotations(this.ignoreAnnotations);
            request.setIgnoreIdentifiers(this.ignoreIdentifiers);
            request.setIgnoreLiterals(this.ignoreLiterals);
            request.setSourceEncoding(this.getInputEncoding());
            request.addFiles(this.filesToProcess.keySet());
            request.setLogLevel(this.determineCurrentRootLogLevel());
            request.setExcludeFromFailureFile(this.excludeFromFailureFile);
            request.setTargetDirectory(this.targetDirectory.getAbsolutePath());
            request.setOutputEncoding(this.getOutputEncoding());
            request.setFormat(this.format);
            request.setIncludeXmlInSite(this.includeXmlInSite);
            request.setReportOutputDirectory(this.getReportOutputDirectory().getAbsolutePath());
            Toolchain tc = this.getToolchain();
            if (tc != null) {
                this.getLog().info((CharSequence)("Toolchain in maven-pmd-plugin: " + tc));
                String javaExecutable = tc.findTool("java");
                request.setJavaExecutable(javaExecutable);
            }
            this.cpdResult = CpdExecutor.execute(request);
        }
        catch (UnsupportedEncodingException e) {
            throw new MavenReportException("Encoding '" + this.getInputEncoding() + "' is not supported.", (Exception)e);
        }
        catch (IOException e) {
            throw new MavenReportException(e.getMessage(), (Exception)e);
        }
    }

    public String getOutputName() {
        return "cpd";
    }
}

