/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.gpg;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public abstract class AbstractGpgSigner {
    public static final String SIGNATURE_EXTENSION = ".asc";
    protected boolean useAgent;
    protected boolean isInteractive = true;
    protected boolean defaultKeyring = true;
    protected String keyname;
    private Log log;
    protected String passphrase;
    protected boolean terminatePassphrase;
    private File outputDir;
    private File buildDir;
    private File baseDir;
    protected File homeDir;
    protected String secretKeyring;
    protected String publicKeyring;
    protected String lockMode;
    protected List<String> args;

    public Log getLog() {
        return this.log;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public void setInteractive(boolean b) {
        this.isInteractive = b;
    }

    public void setLockMode(String lockMode) {
        this.lockMode = lockMode;
    }

    public void setUseAgent(boolean b) {
        this.useAgent = b;
    }

    public void setDefaultKeyring(boolean enabled) {
        this.defaultKeyring = enabled;
    }

    public void setKeyName(String s) {
        this.keyname = s;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setPassPhrase(String s) {
        this.passphrase = s;
    }

    public void setTerminatePassphrase(boolean b) {
        this.terminatePassphrase = b;
    }

    public void setOutputDirectory(File out) {
        this.outputDir = out;
    }

    public void setBuildDirectory(File out) {
        this.buildDir = out;
    }

    public void setBaseDirectory(File out) {
        this.baseDir = out;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDir = homeDirectory;
    }

    public void setSecretKeyring(String path) {
        this.secretKeyring = path;
    }

    public void setPublicKeyring(String path) {
        this.publicKeyring = path;
    }

    public abstract String signerName();

    public void prepare() throws MojoFailureException {
    }

    public abstract String getKeyInfo();

    public File generateSignatureForArtifact(File file) throws MojoExecutionException {
        File parent;
        File signature = new File(file + SIGNATURE_EXTENSION);
        boolean isInBuildDir = false;
        if (this.buildDir != null && this.buildDir.equals(parent = signature.getParentFile())) {
            isInBuildDir = true;
        }
        if (!isInBuildDir && this.outputDir != null) {
            String fileDirectory = "";
            File signatureDirectory = signature;
            while ((signatureDirectory = signatureDirectory.getParentFile()) != null && !this.isPossibleRootOfArtifact(signatureDirectory)) {
                fileDirectory = signatureDirectory.getName() + File.separatorChar + fileDirectory;
            }
            signatureDirectory = new File(this.outputDir, fileDirectory);
            if (!signatureDirectory.exists()) {
                signatureDirectory.mkdirs();
            }
            signature = new File(signatureDirectory, file.getName() + SIGNATURE_EXTENSION);
        }
        if (signature.exists()) {
            signature.delete();
        }
        this.generateSignatureForFile(file, signature);
        return signature;
    }

    protected abstract void generateSignatureForFile(File var1, File var2) throws MojoExecutionException;

    private boolean isPossibleRootOfArtifact(File signatureDirectory) {
        return signatureDirectory.equals(this.outputDir) || signatureDirectory.equals(this.buildDir) || signatureDirectory.equals(this.baseDir);
    }
}

