/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.ide.IdeUtils;

public class RemoveCacheMojo
extends AbstractMojo {
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)Messages.getString("RemoveCacheMojo.checking"));
        List notAvailableMarkerFiles = this.getNotAvailableMarkerFiles();
        if (!notAvailableMarkerFiles.isEmpty()) {
            this.deleteMarkerFiles(notAvailableMarkerFiles);
        }
        this.getLog().info((CharSequence)Messages.getString("RemoveCacheMojo.complete"));
    }

    private void deleteMarkerFiles(List notAvailableMarkerFiles) {
        for (File markerFile : notAvailableMarkerFiles) {
            try {
                IdeUtils.delete(markerFile, this.getLog());
            }
            catch (MojoExecutionException e) {
                this.getLog().warn((CharSequence)e.getMessage(), (Throwable)e);
            }
        }
    }

    private List getNotAvailableMarkerFiles() {
        File localRepositoryBaseDirectory = new File(this.localRepository.getBasedir());
        ArrayList<File> markerFiles = new ArrayList<File>();
        Iterator iterator = FileUtils.iterateFiles((File)localRepositoryBaseDirectory, (IOFileFilter)new SuffixFileFilter("-not-available"), (IOFileFilter)TrueFileFilter.INSTANCE);
        while (iterator.hasNext()) {
            File notAvailableMarkerFile = (File)iterator.next();
            markerFiles.add(notAvailableMarkerFile);
        }
        return markerFiles;
    }
}

