/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.eclipse.writers.rad;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.eclipse.Messages;
import org.apache.maven.plugin.eclipse.writers.AbstractEclipseWriter;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.PrettyPrintXMLWriter;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;

public class RadEjbClasspathWriter
extends AbstractEclipseWriter {
    private static final String CLASSPATH = "classpath";
    private static final String CLASSPATH_FILE = ".classpath";
    private static final String CLASSPATHENTRY = "classpathentry";
    private static final String CON = "con";
    private static final String KIND = "kind";
    private static final String LIB = "lib";
    private static final String OUTPUT = "output";
    private static final String PATH = "path";
    private static final String SRC = "src";
    private static final String TARGET_WEBSPHERE_CLASSES = "target/websphere/generated-classes";
    private static final String VAR = "var";
    private static final String WEBSPHERE6CONTAINER = "com.ibm.wtp.server.java.core.container/com.ibm.ws.ast.st.runtime.core.runtimeTarget.v60/was.base.v6";

    public void write() throws MojoExecutionException {
        String packaging = this.config.getPackaging();
        if ("ejb".equalsIgnoreCase(packaging)) {
            OutputStreamWriter w;
            new File(this.config.getEclipseProjectDirectory(), TARGET_WEBSPHERE_CLASSES).mkdirs();
            File classpathFile = new File(this.config.getEclipseProjectDirectory(), CLASSPATH_FILE);
            if (!classpathFile.exists()) {
                return;
            }
            Xpp3Dom classpath = this.readXMLFile(classpathFile);
            Xpp3Dom[] children = classpath.getChildren();
            for (int index = 0; index < children.length; ++index) {
                if (!LIB.equals(children[index].getAttribute(KIND)) || !TARGET_WEBSPHERE_CLASSES.equals(children[index].getAttribute(PATH))) continue;
                return;
            }
            Xpp3Dom newEntry = new Xpp3Dom(CLASSPATHENTRY);
            newEntry.setAttribute(KIND, LIB);
            newEntry.setAttribute(PATH, TARGET_WEBSPHERE_CLASSES);
            classpath.addChild(newEntry);
            newEntry = new Xpp3Dom(CLASSPATHENTRY);
            newEntry.setAttribute(KIND, CON);
            newEntry.setAttribute(PATH, WEBSPHERE6CONTAINER);
            classpath.addChild(newEntry);
            children = classpath.getChildren();
            for (int index = children.length - 1; index >= 0; --index) {
                if (children[index].getValue() != null) continue;
                children[index].setValue("");
            }
            this.removeDupicateWAS6Libs(classpath);
            classpath = this.orderClasspath(classpath);
            try {
                w = new OutputStreamWriter((OutputStream)new FileOutputStream(classpathFile), "UTF-8");
            }
            catch (IOException ex) {
                throw new MojoExecutionException(Messages.getString("EclipsePlugin.erroropeningfile"), (Exception)ex);
            }
            PrettyPrintXMLWriter writer = new PrettyPrintXMLWriter((Writer)w, "UTF-8", null);
            Xpp3DomWriter.write((XMLWriter)writer, (Xpp3Dom)classpath);
            IOUtil.close((Writer)w);
        }
    }

    private int detectClasspathEntryType(Xpp3Dom classpathentry) {
        boolean anyAbsolutePath;
        String kind = classpathentry.getAttribute(KIND);
        String path = classpathentry.getAttribute(PATH);
        if (kind == null || path == null) {
            return 6;
        }
        boolean absolutePath = path.startsWith("\\") || path.startsWith("/");
        boolean windowsAbsolutePath = path.indexOf(58) >= 0;
        boolean bl = anyAbsolutePath = absolutePath || windowsAbsolutePath;
        if (kind.equals(SRC) && !absolutePath) {
            return 1;
        }
        if (kind.equals(LIB) && !anyAbsolutePath) {
            return 2;
        }
        if (kind.equals(SRC)) {
            return 3;
        }
        if (kind.equals(VAR)) {
            return 4;
        }
        if (kind.equals(LIB)) {
            return 5;
        }
        if (kind.equals(OUTPUT)) {
            return 7;
        }
        return 6;
    }

    private Xpp3Dom orderClasspath(Xpp3Dom classpath) {
        Xpp3Dom[] children = classpath.getChildren();
        Arrays.sort(children, new Comparator(){

            public int compare(Object o1, Object o2) {
                return RadEjbClasspathWriter.this.detectClasspathEntryType((Xpp3Dom)o1) - RadEjbClasspathWriter.this.detectClasspathEntryType((Xpp3Dom)o2);
            }
        });
        Xpp3Dom resultClasspath = new Xpp3Dom(CLASSPATH);
        for (int index = 0; index < children.length; ++index) {
            resultClasspath.addChild(children[index]);
        }
        return resultClasspath;
    }

    private Xpp3Dom readXMLFile(File xmlFile) {
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(xmlFile), "UTF-8");
            Xpp3Dom applicationXmlDom = Xpp3DomBuilder.build((Reader)reader);
            return applicationXmlDom;
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            this.log.error((CharSequence)Messages.getString("EclipsePlugin.cantreadfile", xmlFile.getAbsolutePath()));
            return null;
        }
    }

    private void removeDupicateWAS6Libs(Xpp3Dom classpath) {
        Xpp3Dom[] children = classpath.getChildren();
        block2: for (int index = children.length - 1; index >= 0; --index) {
            try {
                File path = new File(children[index].getAttribute(PATH));
                if (!path.exists() || !path.getParentFile().getName().equals(LIB) || !path.getParentFile().getParentFile().getName().equals("base_v6") || !path.getParentFile().getParentFile().getParentFile().getName().equals("runtimes")) continue;
                Xpp3Dom[] currentChildren = classpath.getChildren();
                for (int deleteIndex = currentChildren.length - 1; deleteIndex >= 0; --deleteIndex) {
                    if (currentChildren[deleteIndex] != children[index]) continue;
                    classpath.removeChild(deleteIndex);
                    continue block2;
                }
                continue;
            }
            catch (Exception e) {
                this.log.debug((Throwable)e);
            }
        }
    }
}

