/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import org.codehaus.plexus.util.xml.XMLWriter;

public class EjbRef {
    static final String DESCRIPTION = "description";
    static final String EJB_REF = "ejb-ref";
    static final String EJB_NAME = "ejb-ref-name";
    static final String EJB_TYPE = "ejb-ref-type";
    static final String EJB_LOOKUP_NAME = "lookup-name";
    private final String description;
    private String name;
    private String type;
    private String lookupName;

    public EjbRef(String description, String name, String type, String lookupName) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("ejb-ref-name in ejb-ref element cannot be null.");
        }
        if ((type == null || type.isEmpty()) && (lookupName == null || lookupName.isEmpty())) {
            throw new IllegalArgumentException("ejb-ref-type in ejb-ref element cannot be null if no lookup-name was specified.");
        }
        this.description = description;
        this.name = name;
        this.type = type;
        this.lookupName = lookupName;
    }

    public void appendEjbRefEntry(XMLWriter writer) {
        writer.startElement(EJB_REF);
        if (this.getDescription() != null) {
            this.doWriteElement(writer, DESCRIPTION, this.getDescription());
        }
        this.doWriteElement(writer, EJB_NAME, this.getName());
        if (this.getType() != null) {
            this.doWriteElement(writer, EJB_TYPE, this.getType());
        }
        if (this.getLookupName() != null) {
            this.doWriteElement(writer, EJB_LOOKUP_NAME, this.getLookupName());
        }
        writer.endElement();
    }

    private void doWriteElement(XMLWriter writer, String element, String text) {
        writer.startElement(element);
        writer.writeText(text);
        writer.endElement();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getLookupName() {
        return this.lookupName;
    }

    public void setLookupName(String lookupName) {
        this.lookupName = lookupName;
    }

    public String getDescription() {
        return this.description;
    }
}

