/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.ear;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderMismatchException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.ear.AbstractEarMojo;
import org.apache.maven.plugins.ear.EarModule;
import org.apache.maven.plugins.ear.EarModuleFactory;
import org.apache.maven.plugins.ear.WebModule;
import org.apache.maven.plugins.ear.util.EarMavenArchiver;
import org.apache.maven.plugins.ear.util.JavaEEVersion;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.filtering.AbstractMavenFilteringRequest;
import org.apache.maven.shared.filtering.FilterWrapper;
import org.apache.maven.shared.filtering.MavenFileFilter;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.maven.shared.filtering.MavenResourcesExecution;
import org.apache.maven.shared.filtering.MavenResourcesFiltering;
import org.apache.maven.shared.mapping.MappingUtils;
import org.apache.maven.shared.utils.io.FileUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.ear.EarArchiver;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="ear", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class EarMojo
extends AbstractEarMojo {
    private static final String ARTIFACT_DEFAULT_FILE_NAME_MAPPING = "@{artifactId}@-@{version}@@{dashClassifier?}@.@{extension}@";
    @Parameter(defaultValue="${basedir}/src/main/application", required=true)
    private File earSourceDirectory;
    @Parameter(alias="includes", defaultValue="**")
    private String earSourceIncludes;
    @Parameter(alias="excludes")
    private String earSourceExcludes;
    @Parameter(defaultValue="false")
    private boolean filtering;
    @Parameter
    private List<String> filters;
    @Parameter
    private List<String> nonFilteredFileExtensions;
    @Parameter(defaultValue="false")
    private boolean escapedBackslashesInFilePath;
    @Parameter
    protected String escapeString;
    @Parameter(defaultValue="false")
    private boolean skipClassPathModification;
    @Parameter
    private File applicationXml;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    private String outputDirectory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Parameter
    private String unpackTypes;
    @Parameter
    private String classifier;
    @Parameter
    private String packagingExcludes;
    @Parameter
    private String packagingIncludes;
    @Parameter(defaultValue="false")
    private boolean skinnyWars;
    @Parameter(defaultValue="false")
    private boolean skinnyModules;
    private EarArchiver earArchiver;
    private JarArchiver jarArchiver;
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    private MavenProjectHelper projectHelper;
    private ArchiverManager archiverManager;
    private MavenFileFilter mavenFileFilter;
    private MavenResourcesFiltering mavenResourcesFiltering;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private List<FilterWrapper> filterWrappers;

    @Inject
    public EarMojo(EarArchiver earArchiver, JarArchiver jarArchiver, MavenProjectHelper projectHelper, ArchiverManager archiverManager, MavenFileFilter mavenFileFilter, MavenResourcesFiltering mavenResourcesFiltering) {
        this.earArchiver = earArchiver;
        this.jarArchiver = jarArchiver;
        this.projectHelper = projectHelper;
        this.archiverManager = archiverManager;
        this.mavenFileFilter = mavenFileFilter;
        this.mavenResourcesFiltering = mavenResourcesFiltering;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        JarArchiver theArchiver;
        super.execute();
        File earFile = EarMojo.getEarFile(this.outputDirectory, this.finalName, this.classifier);
        EarMavenArchiver archiver = new EarMavenArchiver(this.getModules());
        File ddFile = new File(this.getWorkDirectory(), "META-INF/application.xml");
        if (ddFile.exists()) {
            this.earArchiver.setAppxml(ddFile);
            theArchiver = this.earArchiver;
        } else {
            theArchiver = this.jarArchiver;
        }
        this.getLog().debug((CharSequence)("Ear archiver implementation [" + theArchiver.getClass().getName() + "]"));
        archiver.setArchiver(theArchiver);
        archiver.setOutputFile(earFile);
        archiver.setCreatedBy("Maven EAR Plugin", "org.apache.maven.plugins", "maven-ear-plugin");
        archiver.configureReproducibleBuild(this.outputTimestamp);
        JavaEEVersion javaEEVersion = JavaEEVersion.getJavaEEVersion(this.version);
        Collection<String> outdatedResources = this.initOutdatedResources();
        List<String> unpackTypesList = this.createUnpackList();
        this.copyModules(javaEEVersion, unpackTypesList, outdatedResources);
        try {
            File earSourceDir = this.earSourceDirectory;
            if (earSourceDir.exists()) {
                String[] fileNames;
                this.getLog().info((CharSequence)("Copy ear sources to " + this.getWorkDirectory().getAbsolutePath()));
                for (String fileName : fileNames = this.getEarFiles(earSourceDir)) {
                    this.copyFile(new File(earSourceDir, fileName), new File(this.getWorkDirectory(), fileName));
                    outdatedResources.remove(Paths.get(fileName, new String[0]).toString());
                }
            }
            if (this.applicationXml != null) {
                this.getLog().info((CharSequence)("Including custom application.xml[" + this.applicationXml + "]"));
                File metaInfDir = new File(this.getWorkDirectory(), "META-INF");
                this.copyFile(this.applicationXml, new File(metaInfDir, "/application.xml"));
                outdatedResources.remove(Paths.get("META-INF/application.xml", new String[0]).toString());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR sources", (Exception)e);
        }
        catch (MavenFilteringException e) {
            throw new MojoExecutionException("Error filtering EAR sources", (Exception)((Object)e));
        }
        if (!ddFile.exists() && javaEEVersion.lt(JavaEEVersion.FIVE)) {
            throw new MojoExecutionException("Deployment descriptor: " + ddFile.getAbsolutePath() + " does not exist.");
        }
        outdatedResources.remove(Paths.get("META-INF/application.xml", new String[0]).toString());
        if (this.getJbossConfiguration() != null) {
            outdatedResources.remove(Paths.get("META-INF/jboss-app.xml", new String[0]).toString());
        }
        this.deleteOutdatedResources(outdatedResources);
        try {
            this.getLog().debug((CharSequence)("Excluding " + Arrays.asList(this.getPackagingExcludes()) + " from the generated EAR."));
            this.getLog().debug((CharSequence)("Including " + Arrays.asList(this.getPackagingIncludes()) + " in the generated EAR."));
            archiver.getArchiver().addDirectory(this.getWorkDirectory(), this.getPackagingIncludes(), this.getPackagingExcludes());
            archiver.createArchive(this.session, this.getProject(), this.archive);
        }
        catch (IOException | DependencyResolutionRequiredException | ManifestException e) {
            throw new MojoExecutionException("Error assembling EAR", (Exception)e);
        }
        if (this.classifier != null) {
            this.projectHelper.attachArtifact(this.getProject(), "ear", this.classifier, earFile);
        } else {
            this.getProject().getArtifact().setFile(earFile);
        }
    }

    private void copyModules(JavaEEVersion javaEEVersion, List<String> unpackTypesList, Collection<String> outdatedResources) throws MojoExecutionException, MojoFailureException {
        try {
            for (EarModule module : this.getModules()) {
                File sourceFile = module.getArtifact().getFile();
                File destinationFile = EarMojo.buildDestinationFile(this.getWorkDirectory(), module.getUri());
                if (!sourceFile.isFile()) {
                    throw new MojoExecutionException("Cannot copy a directory: " + sourceFile.getAbsolutePath() + "; Did you package/install " + module.getArtifact() + "?");
                }
                if (destinationFile.getCanonicalPath().equals(sourceFile.getCanonicalPath())) {
                    this.getLog().info((CharSequence)("Skipping artifact [" + module + "], as it already exists at [" + module.getUri() + "]"));
                    continue;
                }
                if (unpackTypesList.contains(module.getType()) && (module.shouldUnpack() == null || module.shouldUnpack().booleanValue()) || module.shouldUnpack() != null && module.shouldUnpack().booleanValue()) {
                    this.getLog().info((CharSequence)("Copying artifact [" + module + "] to [" + module.getUri() + "] (unpacked)"));
                    if (!destinationFile.isDirectory() && !destinationFile.mkdirs()) {
                        throw new MojoExecutionException("Error creating " + destinationFile);
                    }
                    this.unpack(sourceFile, destinationFile, outdatedResources);
                    if (!module.changeManifestClasspath()) continue;
                    this.changeManifestClasspath(module, destinationFile, javaEEVersion, outdatedResources);
                    continue;
                }
                if (sourceFile.lastModified() > destinationFile.lastModified()) {
                    this.getLog().info((CharSequence)("Copying artifact [" + module + "] to [" + module.getUri() + "]"));
                    this.createParentIfNecessary(destinationFile);
                    Files.copy(sourceFile.toPath(), destinationFile.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
                    if (module.changeManifestClasspath()) {
                        this.changeManifestClasspath(module, destinationFile, javaEEVersion, outdatedResources);
                    }
                } else {
                    this.getLog().debug((CharSequence)("Skipping artifact [" + module + "], as it is already up to date at [" + module.getUri() + "]"));
                }
                this.removeFromOutdatedResources(destinationFile.toPath(), outdatedResources);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying EAR modules", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking EAR modules", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("No Archiver found for EAR modules", (Exception)((Object)e));
        }
    }

    private List<String> createUnpackList() throws MojoExecutionException {
        List<String> unpackTypesList = new ArrayList<String>();
        if (this.unpackTypes != null) {
            unpackTypesList = Arrays.asList(this.unpackTypes.split(","));
            for (String type : unpackTypesList) {
                if (EarModuleFactory.isStandardArtifactType(type)) continue;
                throw new MojoExecutionException("Invalid type [" + type + "] supported types are " + EarModuleFactory.getStandardArtifactTypes());
            }
            this.getLog().debug((CharSequence)("Initialized unpack types " + unpackTypesList));
        }
        return unpackTypesList;
    }

    public File getApplicationXml() {
        return this.applicationXml;
    }

    public void setApplicationXml(File applicationXml) {
        this.applicationXml = applicationXml;
    }

    protected String[] getExcludes() {
        ArrayList<String> excludeList = new ArrayList<String>(FileUtils.getDefaultExcludesAsList());
        if (this.earSourceExcludes != null && !"".equals(this.earSourceExcludes)) {
            excludeList.addAll(Arrays.asList(StringUtils.split((String)this.earSourceExcludes, (String)",")));
        }
        if (this.getApplicationXml() != null && !"".equals(this.getApplicationXml())) {
            excludeList.add("**/META-INF/application.xml");
        }
        return excludeList.toArray(new String[excludeList.size()]);
    }

    protected String[] getIncludes() {
        return StringUtils.split((String)Objects.toString(this.earSourceIncludes, ""), (String)",");
    }

    public String[] getPackagingExcludes() {
        if (this.packagingExcludes == null || this.packagingExcludes.isEmpty()) {
            return new String[0];
        }
        return StringUtils.split((String)this.packagingExcludes, (String)",");
    }

    public void setPackagingExcludes(String packagingExcludes) {
        this.packagingExcludes = packagingExcludes;
    }

    public String[] getPackagingIncludes() {
        if (this.packagingIncludes == null || this.packagingIncludes.isEmpty()) {
            return new String[]{"**"};
        }
        return StringUtils.split((String)this.packagingIncludes, (String)",");
    }

    public void setPackagingIncludes(String packagingIncludes) {
        this.packagingIncludes = packagingIncludes;
    }

    private static File buildDestinationFile(File buildDir, String uri) {
        return new File(buildDir, uri);
    }

    private static File getEarFile(String basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        return new File(basedir, finalName + classifier + ".ear");
    }

    private String[] getEarFiles(File sourceDir) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDir);
        scanner.setExcludes(this.getExcludes());
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.getIncludes());
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void unpack(File source, File destDir, Collection<String> outdatedResources) throws ArchiverException, NoSuchArchiverException, IOException {
        Path destPath = destDir.toPath();
        UnArchiver unArchiver = this.archiverManager.getUnArchiver("zip");
        unArchiver.setSourceFile(source);
        unArchiver.setDestDirectory(destDir);
        unArchiver.setFileMappers(new FileMapper[]{pName -> {
            this.removeFromOutdatedResources(destPath.resolve(pName), outdatedResources);
            return pName;
        }});
        unArchiver.extract();
    }

    private void copyFile(File source, File target) throws MavenFilteringException, IOException, MojoExecutionException {
        this.createParentIfNecessary(target);
        if (this.filtering && !this.isNonFilteredExtension(source.getName())) {
            this.mavenFileFilter.copyFile(source, target, true, this.getFilterWrappers(), this.encoding);
        } else {
            Files.copy(source.toPath(), target.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void createParentIfNecessary(File target) throws IOException {
        File parentDirectory = target.getParentFile();
        if (parentDirectory != null && !parentDirectory.exists()) {
            Files.createDirectories(parentDirectory.toPath(), new FileAttribute[0]);
        }
    }

    public boolean isNonFilteredExtension(String fileName) {
        return !this.mavenResourcesFiltering.filteredFileExtension(fileName, this.nonFilteredFileExtensions);
    }

    private List<FilterWrapper> getFilterWrappers() throws MojoExecutionException {
        if (this.filterWrappers == null) {
            try {
                MavenResourcesExecution mavenResourcesExecution = new MavenResourcesExecution();
                mavenResourcesExecution.setMavenProject(this.getProject());
                mavenResourcesExecution.setEscapedBackslashesInFilePath(this.escapedBackslashesInFilePath);
                mavenResourcesExecution.setFilters(this.filters);
                mavenResourcesExecution.setEscapeString(this.escapeString);
                this.filterWrappers = this.mavenFileFilter.getDefaultFilterWrappers((AbstractMavenFilteringRequest)mavenResourcesExecution);
            }
            catch (MavenFilteringException e) {
                this.getLog().error((CharSequence)("Fail to build filtering wrappers " + e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
        }
        return this.filterWrappers;
    }

    private void changeManifestClasspath(EarModule module, File original, JavaEEVersion javaEEVersion, Collection<String> outdatedResources) throws MojoFailureException {
        String moduleLibDir = module.getLibDir();
        if (!(moduleLibDir == null || this.skinnyModules || this.skinnyWars && module instanceof WebModule)) {
            return;
        }
        FileTime outputFileTime = MavenArchiver.parseBuildOutputTimestamp((String)this.outputTimestamp).map(FileTime::from).orElse(null);
        FileSystem fileSystem = null;
        try {
            boolean classPathExists;
            Path manifestFile;
            Path workDirectory;
            if (original.isFile()) {
                fileSystem = FileSystems.newFileSystem(original.toPath(), Thread.currentThread().getContextClassLoader());
                workDirectory = fileSystem.getRootDirectories().iterator().next();
            } else {
                workDirectory = original.toPath();
            }
            Path metaInfDirectory = workDirectory.resolve("META-INF");
            if (!Files.exists(metaInfDirectory, new LinkOption[0])) {
                Files.createDirectory(metaInfDirectory, new FileAttribute[0]);
                if (outputFileTime != null) {
                    Files.setLastModifiedTime(metaInfDirectory, outputFileTime);
                }
                this.getLog().debug((CharSequence)"This project did not have a META-INF directory before, so a new directory was created.");
            }
            if (!Files.exists(manifestFile = metaInfDirectory.resolve("MANIFEST.MF"), new LinkOption[0])) {
                Files.createFile(manifestFile, new FileAttribute[0]);
                if (outputFileTime != null) {
                    Files.setLastModifiedTime(manifestFile, outputFileTime);
                }
                this.getLog().debug((CharSequence)"This project did not have a META-INF/MANIFEST.MF file before, so a new file was created.");
            }
            Manifest mf = EarMojo.readManifest(manifestFile);
            Manifest.ExistingAttribute classPath = mf.getMainSection().getAttribute("Class-Path");
            ArrayList<String> classPathElements = new ArrayList<String>();
            if (classPath != null) {
                classPathExists = true;
                classPathElements.addAll(Arrays.asList(classPath.getValue().split(" ")));
            } else {
                classPathExists = false;
                classPath = new Manifest.Attribute("Class-Path", "");
            }
            if (moduleLibDir != null && (this.skinnyModules || this.skinnyWars && module instanceof WebModule)) {
                for (EarModule otherModule : this.getAllEarModules()) {
                    if (module.equals(otherModule)) continue;
                    Path workLibDir = workDirectory.resolve(moduleLibDir);
                    Path artifact = workLibDir.resolve(module.getArtifact().getFile().getName());
                    if (!Files.exists(artifact, new LinkOption[0])) {
                        this.getLog().debug((CharSequence)"module does not exist with original file name.");
                        artifact = workLibDir.resolve(otherModule.getBundleFileName());
                        this.getLog().debug((CharSequence)("Artifact with mapping: " + artifact.toAbsolutePath()));
                    }
                    if (!Files.exists(artifact, new LinkOption[0])) {
                        this.getLog().debug((CharSequence)"Artifact with mapping does not exist.");
                        artifact = workLibDir.resolve(otherModule.getArtifact().getFile().getName());
                        this.getLog().debug((CharSequence)("Artifact with original file name: " + artifact.toAbsolutePath()));
                    }
                    if (!Files.exists(artifact, new LinkOption[0])) {
                        this.getLog().debug((CharSequence)"Artifact with original file name does not exist.");
                        Artifact otherModuleArtifact = otherModule.getArtifact();
                        if (otherModuleArtifact.isSnapshot()) {
                            try {
                                artifact = workLibDir.resolve(MappingUtils.evaluateFileNameMapping((String)ARTIFACT_DEFAULT_FILE_NAME_MAPPING, (Artifact)otherModuleArtifact));
                                this.getLog().debug((CharSequence)("Artifact with default mapping file name: " + artifact.toAbsolutePath()));
                            }
                            catch (InterpolationException e) {
                                this.getLog().warn((CharSequence)("Failed to evaluate file name for [" + otherModule + "] module using mapping: " + ARTIFACT_DEFAULT_FILE_NAME_MAPPING));
                            }
                        }
                    }
                    if (!Files.exists(artifact, new LinkOption[0])) continue;
                    this.getLog().debug((CharSequence)(" -> Artifact to delete: " + artifact));
                    Files.delete(artifact);
                }
            }
            boolean forceClassPathModification = javaEEVersion.lt(JavaEEVersion.FIVE) || this.defaultLibBundleDir == null;
            boolean classPathExtension = !this.skipClassPathModification || forceClassPathModification;
            for (EarModule otherModule : this.getModules()) {
                if (module.equals(otherModule)) continue;
                int moduleClassPathIndex = this.findModuleInClassPathElements(classPathElements, otherModule);
                if (moduleClassPathIndex != -1) {
                    if (otherModule.isClassPathItem()) {
                        classPathElements.set(moduleClassPathIndex, otherModule.getUri());
                        continue;
                    }
                    classPathElements.remove(moduleClassPathIndex);
                    continue;
                }
                if (!otherModule.isClassPathItem() || !classPathExtension) continue;
                classPathElements.add(otherModule.getUri());
            }
            for (EarModule otherModule : this.getProvidedEarModules()) {
                int moduleClassPathIndex = this.findModuleInClassPathElements(classPathElements, otherModule);
                if (moduleClassPathIndex == -1) continue;
                classPathElements.remove(moduleClassPathIndex);
            }
            if (!this.skipClassPathModification || !classPathElements.isEmpty() || classPathExists) {
                classPath.setValue(StringUtils.join(classPathElements.iterator(), (String)" "));
                mf.getMainSection().addConfiguredAttribute((Manifest.Attribute)classPath);
                FileTime lastModifiedTime = Files.getLastModifiedTime(manifestFile, new LinkOption[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(manifestFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    mf.write((Writer)writer);
                }
                Files.setLastModifiedTime(manifestFile, lastModifiedTime);
                this.removeFromOutdatedResources(manifestFile, outdatedResources);
            }
            if (fileSystem != null) {
                fileSystem.close();
                fileSystem = null;
            }
        }
        catch (IOException | ArchiverException | ManifestException e) {
            throw new MojoFailureException(e.getMessage(), e);
        }
        finally {
            if (fileSystem != null) {
                try {
                    fileSystem.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Manifest readManifest(Path manifestFile) throws IOException {
        try (InputStream in = Files.newInputStream(manifestFile, new OpenOption[0]);){
            Manifest manifest = new Manifest(in);
            return manifest;
        }
    }

    private Collection<String> initOutdatedResources() {
        final ArrayList<String> outdatedResources = new ArrayList<String>();
        if (this.getWorkDirectory().exists()) {
            try {
                Files.walkFileTree(this.getWorkDirectory().toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        outdatedResources.add(EarMojo.this.getWorkDirectory().toPath().relativize(file).toString());
                        return super.visitFile(file, attrs);
                    }
                });
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Can't detect outdated resources", (Throwable)e);
            }
        }
        this.getLog().debug((CharSequence)("initOutdatedResources: " + outdatedResources));
        return outdatedResources;
    }

    private void deleteOutdatedResources(Collection<String> outdatedResources) {
        this.getLog().debug((CharSequence)("deleteOutdatedResources: " + outdatedResources));
        long startTime = this.session.getStartTime().getTime();
        this.getLog().debug((CharSequence)("deleteOutdatedResources session startTime: " + startTime));
        for (String outdatedResource : outdatedResources) {
            File resourceFile = new File(this.getWorkDirectory(), outdatedResource);
            if (resourceFile.lastModified() >= startTime) continue;
            this.getLog().info((CharSequence)("deleting outdated resource " + outdatedResource));
            this.getLog().debug((CharSequence)(outdatedResource + " last modified: " + resourceFile.lastModified()));
            resourceFile.delete();
        }
    }

    private void removeFromOutdatedResources(Path destination, Collection<String> outdatedResources) {
        Path relativeDestFile;
        try {
            relativeDestFile = this.getWorkDirectory().toPath().relativize(destination.normalize());
        }
        catch (ProviderMismatchException e) {
            relativeDestFile = destination.normalize();
        }
        if (outdatedResources.remove(relativeDestFile.toString())) {
            this.getLog().debug((CharSequence)("Remove from outdatedResources: " + relativeDestFile));
        }
    }

    private int findModuleInClassPathElements(List<String> classPathElements, EarModule module) {
        if (classPathElements.isEmpty()) {
            return -1;
        }
        int moduleClassPathIndex = classPathElements.indexOf(module.getBundleFileName());
        if (moduleClassPathIndex != -1) {
            return moduleClassPathIndex;
        }
        Artifact artifact = module.getArtifact();
        moduleClassPathIndex = classPathElements.indexOf(artifact.getFile().getName());
        if (moduleClassPathIndex != -1) {
            return moduleClassPathIndex;
        }
        if (artifact.isSnapshot()) {
            try {
                moduleClassPathIndex = classPathElements.indexOf(MappingUtils.evaluateFileNameMapping((String)ARTIFACT_DEFAULT_FILE_NAME_MAPPING, (Artifact)artifact));
                if (moduleClassPathIndex != -1) {
                    return moduleClassPathIndex;
                }
            }
            catch (InterpolationException e) {
                this.getLog().warn((CharSequence)("Failed to evaluate file name for [" + module + "] module using mapping: " + ARTIFACT_DEFAULT_FILE_NAME_MAPPING));
            }
        }
        return classPathElements.indexOf(module.getUri());
    }
}

