/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils.filters;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.dependency.utils.filters.AbstractArtifactFeatureFilter;

public class GroupIdFilter
extends AbstractArtifactFeatureFilter {
    private String includeScope;
    private String excludeScope;

    public GroupIdFilter(String include, String exclude) {
        super(include, exclude, "GroupId");
        this.includeScope = include;
        this.excludeScope = exclude;
    }

    public String getExcludeScope() {
        return this.excludeScope;
    }

    public String getIncludeScope() {
        return this.includeScope;
    }

    protected String getArtifactFeature(Artifact artifact) {
        return artifact.getGroupId();
    }

    protected boolean compareFeatures(String lhs, String rhs) {
        return lhs.startsWith(rhs);
    }
}

