/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.jira;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.logging.Log;

public class JiraHelper {
    private static final String PID = "?pid=";

    static Map<String, String> getJiraUrlAndProjectId(String issueManagementUrl) {
        String jiraUrl;
        String url = issueManagementUrl;
        if (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf(47));
        }
        int pos = url.indexOf(63);
        String id = "";
        if (pos >= 0) {
            id = url.substring(url.lastIndexOf(61) + 1);
        }
        if ((jiraUrl = url.substring(0, url.lastIndexOf(47))).endsWith("secure")) {
            jiraUrl = jiraUrl.substring(0, jiraUrl.lastIndexOf(47));
        } else {
            int index = jiraUrl.indexOf("/browse");
            if (index != -1) {
                jiraUrl = jiraUrl.substring(0, index);
            }
        }
        HashMap<String, String> urlMap = new HashMap<String, String>(4);
        urlMap.put("url", jiraUrl);
        urlMap.put("id", id);
        return urlMap;
    }

    public static String getPidFromJira(Log log, String issueManagementUrl, HttpClient client) {
        String projectPage;
        String jiraId = null;
        HttpGet request = new HttpGet(issueManagementUrl);
        try {
            HttpResponse response = client.execute((HttpUriRequest)request);
            log.debug((CharSequence)"Successfully reached JIRA.");
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                if (log.isDebugEnabled()) {
                    log.error((CharSequence)"Unable to read the JIRA project page");
                }
                return null;
            }
            projectPage = EntityUtils.toString((HttpEntity)entity);
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.error((CharSequence)"Unable to reach the JIRA project page:", (Throwable)e);
            } else {
                log.error((CharSequence)("Unable to reach the JIRA project page. Cause is: " + e.getLocalizedMessage()));
            }
            return null;
        }
        int pidIndex = projectPage.indexOf(PID);
        if (pidIndex == -1) {
            log.error((CharSequence)("Unable to extract a JIRA pid from the page at the url " + issueManagementUrl));
        } else {
            NumberFormat nf = NumberFormat.getInstance();
            Number pidNumber = nf.parse(projectPage, new ParsePosition(pidIndex + PID.length()));
            jiraId = Integer.toString(pidNumber.intValue());
            log.debug((CharSequence)("Found the pid " + jiraId + " at " + issueManagementUrl));
        }
        return jiraId;
    }

    private JiraHelper() {
    }

    public static Map<String, String> getJiraUrlAndProjectName(String issueManagementUrl) {
        int indexBrowse = issueManagementUrl.indexOf("/browse/");
        HashMap<String, String> urlMap = new HashMap<String, String>(4);
        if (indexBrowse != -1) {
            String jiraUrl = issueManagementUrl.substring(0, indexBrowse);
            urlMap.put("url", jiraUrl);
            int indexBrowseEnd = indexBrowse + "/browse/".length();
            int indexProject = issueManagementUrl.indexOf("/", indexBrowseEnd);
            if (indexProject != -1) {
                String project = issueManagementUrl.substring(indexBrowseEnd, indexProject);
                urlMap.put("project", project);
            } else {
                String project = issueManagementUrl.substring(indexBrowseEnd);
                urlMap.put("project", project);
            }
        } else {
            throw new IllegalArgumentException("Invalid browse URL");
        }
        return urlMap;
    }

    public static String getBaseUrl(String url) {
        int index = url.indexOf("/", 8);
        return url.substring(0, index);
    }
}

