/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.jira;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.changes.AbstractChangesReport;
import org.apache.maven.plugins.changes.ProjectUtils;
import org.apache.maven.plugins.changes.issues.Issue;
import org.apache.maven.plugins.changes.issues.IssueUtils;
import org.apache.maven.plugins.changes.issues.IssuesReportHelper;
import org.apache.maven.plugins.changes.issues.IssuesReportRenderer;
import org.apache.maven.plugins.changes.jira.RestJiraDownloader;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.SettingsDecrypter;

@Mojo(name="jira-changes", threadSafe=true)
public class JiraChangesReport
extends AbstractChangesReport {
    private static final Map<String, Integer> JIRA_COLUMNS = new HashMap<String, Integer>(16);
    @Parameter(defaultValue="Key,Summary,Status,Resolution,Assignee")
    private String columnNames;
    @Deprecated
    @Parameter(property="changes.useJql", defaultValue="false")
    private boolean useJql;
    @Parameter
    private String component;
    @Parameter
    private String filter;
    @Parameter
    private String fixVersionIds;
    @Parameter(defaultValue="EEE, d MMM yyyy HH:mm:ss Z")
    private String jiraDatePattern;
    @Parameter
    private String jiraPassword;
    @Parameter
    private String jiraUser;
    @Parameter(property="changes.jiraServerId")
    private String jiraServerId;
    @Parameter(defaultValue="100")
    private int maxEntries;
    @Parameter(defaultValue="false")
    private boolean onlyCurrentVersion;
    @Parameter
    private String priorityIds;
    @Parameter(defaultValue="Fixed")
    private String resolutionIds;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="changes.jira.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="Priority DESC, Created DESC")
    private String sortColumnNames;
    @Parameter(defaultValue="Closed")
    private String statusIds;
    @Parameter
    private String typeIds;
    @Parameter
    private String versionPrefix;
    @Deprecated
    @Parameter
    private String webPassword;
    @Deprecated
    @Parameter
    private String webUser;
    private RestJiraDownloader mockDownloader;
    private final SettingsDecrypter settingsDecrypter;

    @Inject
    public JiraChangesReport(SettingsDecrypter settingsDecrypter) {
        this.settingsDecrypter = settingsDecrypter;
    }

    public boolean canGenerateReport() {
        if (this.runOnlyAtExecutionRoot && !this.isThisTheExecutionRoot()) {
            this.getLog().info((CharSequence)"Skipping the JIRA Report in this project because it's not the Execution Root");
            return false;
        }
        if (this.skip) {
            return false;
        }
        if (this.mockDownloader != null) {
            return true;
        }
        String message = ProjectUtils.validateIssueManagement(this.project, "JIRA", "JIRA Report");
        if (message != null) {
            this.getLog().warn((CharSequence)message);
        }
        return message == null;
    }

    public void executeReport(Locale locale) throws MavenReportException {
        List<Integer> columnIds = IssuesReportHelper.getColumnIds(this.columnNames, JIRA_COLUMNS);
        if (columnIds.isEmpty()) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + this.columnNames + "' are valid.");
        }
        try {
            RestJiraDownloader issueDownloader = this.mockDownloader != null ? this.mockDownloader : new RestJiraDownloader();
            this.configureIssueDownloader(issueDownloader);
            issueDownloader.doExecute();
            List<Issue> issueList = issueDownloader.getIssueList();
            if (StringUtils.isNotEmpty((CharSequence)this.versionPrefix)) {
                int originalNumberOfIssues = issueList.size();
                issueList = IssueUtils.filterIssuesWithVersionPrefix(issueList, this.versionPrefix);
                this.getLog().debug((CharSequence)("Filtered out " + issueList.size() + " issues of " + originalNumberOfIssues + " that matched the versionPrefix '" + this.versionPrefix + "'."));
            }
            if (this.onlyCurrentVersion) {
                String version = (this.versionPrefix == null ? "" : this.versionPrefix) + this.project.getVersion();
                issueList = IssueUtils.getIssuesForVersion(issueList, version);
                this.getLog().info((CharSequence)"The JIRA Report will contain issues only for the current version.");
            }
            IssuesReportRenderer report = new IssuesReportRenderer(this.getSink(), this.getBundle(locale), columnIds, issueList);
            report.render();
        }
        catch (Exception e) {
            this.getLog().warn((Throwable)e);
        }
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getString("report.issues.description");
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getString("report.issues.name");
    }

    @Deprecated
    public String getOutputName() {
        return "jira-changes";
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("jira-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }

    private void configureIssueDownloader(RestJiraDownloader issueDownloader) {
        issueDownloader.setLog(this.getLog());
        issueDownloader.setMavenProject(this.project);
        issueDownloader.setNbEntries(this.maxEntries);
        issueDownloader.setComponent(this.component);
        issueDownloader.setFixVersionIds(this.fixVersionIds);
        issueDownloader.setStatusIds(this.statusIds);
        issueDownloader.setResolutionIds(this.resolutionIds);
        issueDownloader.setPriorityIds(this.priorityIds);
        issueDownloader.setSortColumnNames(this.sortColumnNames);
        issueDownloader.setFilter(this.filter);
        issueDownloader.setJiraDatePattern(this.jiraDatePattern);
        issueDownloader.setJiraServerId(this.jiraServerId);
        if (this.jiraUser != null) {
            issueDownloader.setJiraUser(this.jiraUser);
            issueDownloader.setJiraPassword(this.jiraPassword);
        } else if (this.webUser != null) {
            issueDownloader.setJiraUser(this.webUser);
            issueDownloader.setJiraPassword(this.webPassword);
        }
        issueDownloader.setTypeIds(this.typeIds);
        issueDownloader.setSettings(this.settings);
        issueDownloader.setSettingsDecrypter(this.settingsDecrypter);
        issueDownloader.setOnlyCurrentVersion(this.onlyCurrentVersion);
        issueDownloader.setVersionPrefix(this.versionPrefix);
    }

    public void setMockDownloader(RestJiraDownloader mockDownloader) {
        this.mockDownloader = mockDownloader;
    }

    static {
        JIRA_COLUMNS.put("Assignee", 0);
        JIRA_COLUMNS.put("Component", 1);
        JIRA_COLUMNS.put("Created", 2);
        JIRA_COLUMNS.put("Fix Version", 3);
        JIRA_COLUMNS.put("Id", 4);
        JIRA_COLUMNS.put("Key", 5);
        JIRA_COLUMNS.put("Priority", 6);
        JIRA_COLUMNS.put("Reporter", 7);
        JIRA_COLUMNS.put("Resolution", 8);
        JIRA_COLUMNS.put("Status", 9);
        JIRA_COLUMNS.put("Summary", 10);
        JIRA_COLUMNS.put("Type", 11);
        JIRA_COLUMNS.put("Updated", 12);
        JIRA_COLUMNS.put("Version", 13);
    }
}

