/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.changes.model.io.xpp3;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.plugins.changes.model.Action;
import org.apache.maven.plugins.changes.model.Author;
import org.apache.maven.plugins.changes.model.Body;
import org.apache.maven.plugins.changes.model.ChangesDocument;
import org.apache.maven.plugins.changes.model.DueTo;
import org.apache.maven.plugins.changes.model.FixedIssue;
import org.apache.maven.plugins.changes.model.Properties;
import org.apache.maven.plugins.changes.model.Release;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ChangesXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, ChangesDocument changesDocument) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(changesDocument.getModelEncoding(), null);
        this.writeChangesDocument(changesDocument, "document", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeAction(Action action, String tagName, XmlSerializer serializer) throws IOException {
        if (action != null) {
            Serializable o;
            Iterator iter;
            serializer.startTag(NAMESPACE, tagName);
            if (action.getDev() != null) {
                serializer.attribute(NAMESPACE, "dev", action.getDev());
            }
            if (action.getDueTo() != null) {
                serializer.attribute(NAMESPACE, "due-to", action.getDueTo());
            }
            if (action.getDueToEmail() != null) {
                serializer.attribute(NAMESPACE, "due-to-email", action.getDueToEmail());
            }
            if (action.getIssue() != null) {
                serializer.attribute(NAMESPACE, "issue", action.getIssue());
            }
            if (action.getType() != null) {
                serializer.attribute(NAMESPACE, "type", action.getType());
            }
            if (action.getSystem() != null) {
                serializer.attribute(NAMESPACE, "system", action.getSystem());
            }
            if (action.getDate() != null) {
                serializer.attribute(NAMESPACE, "date", action.getDate());
            }
            serializer.text(String.valueOf(action.getAction()));
            if (action.getFixedIssues() != null && action.getFixedIssues().size() > 0) {
                iter = action.getFixedIssues().iterator();
                while (iter.hasNext()) {
                    o = (FixedIssue)iter.next();
                    this.writeFixedIssue((FixedIssue)o, "fixes", serializer);
                }
            }
            if (action.getDueTos() != null && action.getDueTos().size() > 0) {
                iter = action.getDueTos().iterator();
                while (iter.hasNext()) {
                    o = (DueTo)iter.next();
                    this.writeDueTo((DueTo)o, "dueto", serializer);
                }
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeAuthor(Author author, String tagName, XmlSerializer serializer) throws IOException {
        if (author != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (author.getAuthorEmail() != null) {
                serializer.attribute(NAMESPACE, "email", author.getAuthorEmail());
            }
            serializer.text(String.valueOf(author.getName()));
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeBody(Body body, String tagName, XmlSerializer serializer) throws IOException {
        if (body != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (body.getReleases() != null && body.getReleases().size() > 0) {
                Iterator iter = body.getReleases().iterator();
                while (iter.hasNext()) {
                    Release o = (Release)iter.next();
                    this.writeRelease(o, "release", serializer);
                }
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeChangesDocument(ChangesDocument changesDocument, String tagName, XmlSerializer serializer) throws IOException {
        if (changesDocument != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (changesDocument.getProperties() != null) {
                this.writeProperties(changesDocument.getProperties(), "properties", serializer);
            }
            if (changesDocument.getBody() != null) {
                this.writeBody(changesDocument.getBody(), "body", serializer);
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeDueTo(DueTo dueTo, String tagName, XmlSerializer serializer) throws IOException {
        if (dueTo != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (dueTo.getName() != null) {
                serializer.attribute(NAMESPACE, "name", dueTo.getName());
            }
            if (dueTo.getEmail() != null) {
                serializer.attribute(NAMESPACE, "email", dueTo.getEmail());
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeFixedIssue(FixedIssue fixedIssue, String tagName, XmlSerializer serializer) throws IOException {
        if (fixedIssue != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (fixedIssue.getIssue() != null) {
                serializer.attribute(NAMESPACE, "issue", fixedIssue.getIssue());
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeProperties(Properties properties, String tagName, XmlSerializer serializer) throws IOException {
        if (properties != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (properties.getTitle() != null) {
                serializer.startTag(NAMESPACE, "title").text(properties.getTitle()).endTag(NAMESPACE, "title");
            }
            if (properties.getAuthor() != null) {
                this.writeAuthor(properties.getAuthor(), "author", serializer);
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }

    private void writeRelease(Release release, String tagName, XmlSerializer serializer) throws IOException {
        if (release != null) {
            serializer.startTag(NAMESPACE, tagName);
            if (release.getVersion() != null) {
                serializer.attribute(NAMESPACE, "version", release.getVersion());
            }
            if (release.getDateRelease() != null) {
                serializer.attribute(NAMESPACE, "date", release.getDateRelease());
            }
            if (release.getDescription() != null) {
                serializer.attribute(NAMESPACE, "description", release.getDescription());
            }
            if (release.getActions() != null && release.getActions().size() > 0) {
                Iterator iter = release.getActions().iterator();
                while (iter.hasNext()) {
                    Action o = (Action)iter.next();
                    this.writeAction(o, "action", serializer);
                }
            }
            serializer.endTag(NAMESPACE, tagName);
        }
    }
}

