/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.trac;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.plugin.trac.TracTicket;
import org.apache.maven.reporting.MavenReportException;

public class TracReportGenerator {
    private static final int COLUMN_ID = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_SUMMARY = 2;
    private static final int COLUMN_STATUS = 3;
    private static final int COLUMN_RESOLUTION = 4;
    private static final int COLUMN_MILESTONE = 5;
    private static final int COLUMN_OWNER = 6;
    private static final int COLUMN_PRIORITY = 7;
    private static final int COLUMN_REPORTER = 8;
    private static final int COLUMN_COMPONENT = 9;
    private static final int COLUMN_CREATED = 10;
    private static final int COLUMN_CHANGED = 11;
    private static final String[] TRAC_COLUMNS = new String[]{"id", "type", "summary", "status", "resolution", "milestone", "owner", "priority", "reporter", "component", "created", "changed"};
    private int[] columnOrder;

    public TracReportGenerator(String columnNames) throws MavenReportException {
        String[] columnNamesArray = columnNames.split(",");
        int validColumnNames = 0;
        this.columnOrder = new int[columnNamesArray.length];
        block0: for (int i = 0; i < this.columnOrder.length; ++i) {
            this.columnOrder[i] = -1;
            for (int columnIndex = 0; columnIndex < TRAC_COLUMNS.length; ++columnIndex) {
                String columnName = columnNamesArray[i].trim();
                if (!TRAC_COLUMNS[columnIndex].equalsIgnoreCase(columnName)) continue;
                this.columnOrder[i] = columnIndex;
                ++validColumnNames;
                continue block0;
            }
        }
        if (validColumnNames == 0) {
            throw new MavenReportException("maven-changes-plugin: None of the configured columnNames '" + columnNames + "' are valid.");
        }
    }

    public void doGenerateEmptyReport(ResourceBundle bundle, Sink sink) {
        this.sinkBeginReport(sink, bundle);
        sink.paragraph();
        sink.text(bundle.getString("report.trac.error"));
        sink.paragraph_();
        this.sinkEndReport(sink);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink, ArrayList ticketList) {
        this.sinkBeginReport(sink, bundle);
        this.constructHeaderRow(sink, ticketList, bundle);
        this.constructDetailRows(sink, ticketList, bundle);
        this.sinkEndReport(sink);
    }

    private void constructHeaderRow(Sink sink, List ticketList, ResourceBundle bundle) {
        if (ticketList == null) {
            return;
        }
        sink.table();
        sink.tableRow();
        block14: for (int columnIndex = 0; columnIndex < this.columnOrder.length; ++columnIndex) {
            switch (this.columnOrder[columnIndex]) {
                case 0: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.id"));
                    continue block14;
                }
                case 1: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.type"));
                    continue block14;
                }
                case 2: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.summary"));
                    continue block14;
                }
                case 6: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.owner"));
                    continue block14;
                }
                case 8: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.reporter"));
                    continue block14;
                }
                case 7: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.priority"));
                    continue block14;
                }
                case 3: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.status"));
                    continue block14;
                }
                case 4: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.resolution"));
                    continue block14;
                }
                case 10: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.created"));
                    continue block14;
                }
                case 11: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.changed"));
                    continue block14;
                }
                case 5: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.milestone"));
                    continue block14;
                }
                case 9: {
                    this.sinkHeader(sink, bundle.getString("report.trac.label.component"));
                    continue block14;
                }
            }
        }
        sink.tableRow_();
    }

    private void constructDetailRows(Sink sink, List ticketList, ResourceBundle bundle) {
        if (ticketList == null) {
            return;
        }
        for (int idx = 0; idx < ticketList.size(); ++idx) {
            SimpleDateFormat sdf = new SimpleDateFormat(bundle.getString("report.trac.dateformat"));
            TracTicket ticket = (TracTicket)ticketList.get(idx);
            sink.tableRow();
            block15: for (int columnIndex = 0; columnIndex < this.columnOrder.length; ++columnIndex) {
                switch (this.columnOrder[columnIndex]) {
                    case 0: {
                        sink.tableCell();
                        sink.link(ticket.getLink());
                        sink.text(ticket.getId());
                        sink.link_();
                        sink.tableCell_();
                        continue block15;
                    }
                    case 1: {
                        this.sinkCell(sink, ticket.getType());
                        continue block15;
                    }
                    case 2: {
                        this.sinkCell(sink, ticket.getSummary());
                        continue block15;
                    }
                    case 6: {
                        this.sinkCell(sink, ticket.getOwner());
                        continue block15;
                    }
                    case 8: {
                        this.sinkCell(sink, ticket.getReporter());
                        continue block15;
                    }
                    case 7: {
                        this.sinkCell(sink, ticket.getPriority());
                        continue block15;
                    }
                    case 3: {
                        this.sinkCell(sink, ticket.getStatus());
                        continue block15;
                    }
                    case 4: {
                        this.sinkCell(sink, ticket.getResolution());
                        continue block15;
                    }
                    case 10: {
                        this.sinkCell(sink, sdf.format(ticket.getTimeCreated()));
                        continue block15;
                    }
                    case 11: {
                        this.sinkCell(sink, sdf.format(ticket.getTimeChanged()));
                        continue block15;
                    }
                    case 5: {
                        this.sinkCell(sink, ticket.getMilestone());
                        continue block15;
                    }
                    case 9: {
                        this.sinkCell(sink, ticket.getComponent());
                        continue block15;
                    }
                }
            }
            sink.tableRow_();
        }
        sink.table_();
    }

    private void sinkBeginReport(Sink sink, ResourceBundle bundle) {
        sink.head();
        sink.text(bundle.getString("report.trac.header"));
        sink.head_();
        sink.body();
        sink.section1();
        this.sinkSectionTitle1(sink, bundle.getString("report.trac.header"));
    }

    private void sinkEndReport(Sink sink) {
        sink.section1_();
        sink.body_();
        sink.flush();
        sink.close();
    }

    private void sinkFigure(Sink sink, String image) {
        sink.figure();
        sink.figureGraphics(image);
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        if (text != null) {
            sink.text(text);
        } else {
            sink.rawText("&nbsp;");
        }
        sink.tableCell_();
    }

    private void sinkSectionTitle1(Sink sink, String text) {
        sink.sectionTitle1();
        sink.text(text);
        sink.sectionTitle1_();
    }
}

