/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.javadoc;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.tools.plugin.javadoc.FullyQualifiedJavadocReference;
import org.apache.maven.tools.plugin.javadoc.JavadocLinkGenerator;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.proxy.ProxyUtils;
import org.codehaus.plexus.util.StringUtils;

class JavadocSite {
    private static final String PREFIX_MODULE = "module:";
    final URI baseUri;
    final Settings settings;
    final Map<String, String> containedPackageNamesAndModules;
    final boolean requireModuleNameInPath;
    static final EnumMap<FullyQualifiedJavadocReference.MemberType, EnumSet<JavadocLinkGenerator.JavadocToolVersionRange>> VERSIONS_PER_TYPE = new EnumMap(FullyQualifiedJavadocReference.MemberType.class);
    JavadocLinkGenerator.JavadocToolVersionRange version;
    public static final int DEFAULT_TIMEOUT = 2000;

    JavadocSite(URI url, Settings settings) throws IOException {
        Map<String, String> containedPackageNamesAndModules;
        boolean requireModuleNameInPath;
        block18: {
            requireModuleNameInPath = false;
            try {
                containedPackageNamesAndModules = JavadocSite.getPackageListWithModules(url.resolve("package-list"), settings);
            }
            catch (FileNotFoundException e) {
                try {
                    containedPackageNamesAndModules = JavadocSite.getPackageListWithModules(url.resolve("element-list"), settings);
                    Optional<String> firstModuleName = containedPackageNamesAndModules.values().stream().filter(StringUtils::isNotBlank).findFirst();
                    if (!firstModuleName.isPresent()) break block18;
                    try (BufferedReader reader = JavadocSite.getReader(url.resolve(firstModuleName.get() + "/module-summary.html").toURL(), null);){
                        requireModuleNameInPath = true;
                    }
                    catch (IOException iOException) {}
                }
                catch (FileNotFoundException e2) {
                    throw new IOException("Found neither 'package-list' nor 'element-list' below url " + url + ". The given URL does probably not specify the root of a javadoc site or has been generated with javadoc 1.2 or older.");
                }
            }
        }
        this.containedPackageNamesAndModules = containedPackageNamesAndModules;
        this.baseUri = url;
        this.settings = settings;
        this.version = null;
        this.requireModuleNameInPath = requireModuleNameInPath;
    }

    JavadocSite(URI url, JavadocLinkGenerator.JavadocToolVersionRange version, boolean requireModuleNameInPath) {
        Objects.requireNonNull(url);
        this.baseUri = url;
        Objects.requireNonNull(version);
        this.version = version;
        this.settings = null;
        this.containedPackageNamesAndModules = Collections.emptyMap();
        this.requireModuleNameInPath = requireModuleNameInPath;
    }

    static Map<String, String> getPackageListWithModules(URI url, Settings settings) throws IOException {
        HashMap<String, String> containedPackageNamesAndModules = new HashMap<String, String>();
        try (BufferedReader reader = JavadocSite.getReader(url.toURL(), settings);){
            String line;
            String module = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(PREFIX_MODULE)) {
                    module = line.substring(PREFIX_MODULE.length());
                    continue;
                }
                containedPackageNamesAndModules.put(line, module);
            }
            HashMap<String, String> hashMap = containedPackageNamesAndModules;
            return hashMap;
        }
    }

    static boolean findLineContaining(URI url, Settings settings, Pattern pattern) throws IOException {
        try (BufferedReader reader = JavadocSite.getReader(url.toURL(), settings);){
            boolean bl = reader.lines().anyMatch(pattern.asPredicate());
            return bl;
        }
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public boolean hasEntryFor(Optional<String> moduleName, Optional<String> packageName) {
        if (this.containedPackageNamesAndModules.isEmpty()) {
            throw new UnsupportedOperationException("Operation hasEntryFor(...) is not supported for offline javadoc sites");
        }
        if (packageName.isPresent()) {
            if (moduleName.isPresent()) {
                String actualModuleName = this.containedPackageNamesAndModules.get(packageName.get());
                if (!moduleName.get().equals(actualModuleName)) {
                    return false;
                }
            } else if (!this.containedPackageNamesAndModules.containsKey(packageName.get())) {
                return false;
            }
        } else if (moduleName.isPresent()) {
            if (!this.containedPackageNamesAndModules.containsValue(moduleName.get())) {
                return false;
            }
        } else {
            throw new IllegalArgumentException("Either module name or package name must be set!");
        }
        return true;
    }

    public URI createLink(String packageName, String className) {
        try {
            if (className.endsWith("[]")) {
                className = className.substring(0, className.length() - 2);
            }
            return JavadocSite.createLink(this.baseUri, Optional.empty(), Optional.of(packageName), Optional.of(className));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create link for " + packageName + "." + className, e);
        }
    }

    static Map.Entry<String, String> getPackageAndClassName(String binaryName) {
        int indexOfDotBetweenPackageAndClass;
        int indexOfDollar = binaryName.indexOf(36);
        if (indexOfDollar >= 0) {
            if (Character.isDigit(binaryName.charAt(indexOfDollar + 1))) {
                throw new IllegalArgumentException("Can only resolve binary names of member classes, but not local or anonymous classes");
            }
            indexOfDotBetweenPackageAndClass = binaryName.lastIndexOf(46, indexOfDollar);
            binaryName = binaryName.replace('$', '.');
        } else {
            indexOfDotBetweenPackageAndClass = binaryName.lastIndexOf(46);
        }
        if (indexOfDotBetweenPackageAndClass < 0) {
            throw new IllegalArgumentException("Resolving primitives is not supported. Binary name must contain at least one dot: " + binaryName);
        }
        if (indexOfDotBetweenPackageAndClass == binaryName.length() - 1) {
            throw new IllegalArgumentException("Invalid binary name ending with a dot: " + binaryName);
        }
        String packageName = binaryName.substring(0, indexOfDotBetweenPackageAndClass);
        String className = binaryName.substring(indexOfDotBetweenPackageAndClass + 1, binaryName.length());
        return new AbstractMap.SimpleEntry<String, String>(packageName, className);
    }

    public URI createLink(FullyQualifiedJavadocReference javadocReference) throws IllegalArgumentException {
        Optional<String> moduleName = !this.requireModuleNameInPath ? Optional.empty() : Optional.ofNullable(javadocReference.getModuleName().orElse(this.containedPackageNamesAndModules.get(javadocReference.getPackageName().orElse(null))));
        return JavadocSite.createLink(javadocReference, this.baseUri, this::appendMemberAsFragment, moduleName);
    }

    static URI createLink(FullyQualifiedJavadocReference javadocReference, URI baseUri, BiFunction<URI, FullyQualifiedJavadocReference, URI> fragmentAppender) {
        return JavadocSite.createLink(javadocReference, baseUri, fragmentAppender, Optional.empty());
    }

    static URI createLink(FullyQualifiedJavadocReference javadocReference, URI baseUri, BiFunction<URI, FullyQualifiedJavadocReference, URI> fragmentAppender, Optional<String> pathPrefix) throws IllegalArgumentException {
        try {
            URI uri = JavadocSite.createLink(baseUri, javadocReference.getModuleName(), javadocReference.getPackageName(), javadocReference.getClassName());
            return fragmentAppender.apply(uri, javadocReference);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Could not create link for " + javadocReference, e);
        }
    }

    static URI createLink(URI baseUri, Optional<String> moduleName, Optional<String> packageName, Optional<String> className) throws URISyntaxException {
        StringBuilder link = new StringBuilder();
        if (moduleName.isPresent()) {
            link.append(moduleName.get() + "/");
        }
        if (packageName.isPresent()) {
            link.append(packageName.get().replace('.', '/'));
        }
        if (!className.isPresent()) {
            if (packageName.isPresent()) {
                link.append("/package-summary.html");
            } else if (moduleName.isPresent()) {
                link.append("/module-summary.html");
            }
        } else {
            link.append('/').append(className.get()).append(".html");
        }
        return baseUri.resolve(new URI(null, link.toString(), null));
    }

    URI appendMemberAsFragment(URI url, FullyQualifiedJavadocReference reference) {
        try {
            return this.appendMemberAsFragment(url, reference.getMember(), reference.getMemberType());
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalArgumentException("Could not create link for " + reference, e);
        }
    }

    URI appendMemberAsFragment(URI url, Optional<String> optionalMember, Optional<FullyQualifiedJavadocReference.MemberType> optionalMemberType) throws URISyntaxException, IOException {
        String member;
        if (!optionalMember.isPresent()) {
            return url;
        }
        FullyQualifiedJavadocReference.MemberType memberType = optionalMemberType.orElse(null);
        String fragment = member = optionalMember.get();
        if (this.version != null) {
            fragment = JavadocSite.getFragmentForMember(this.version, member, memberType == FullyQualifiedJavadocReference.MemberType.CONSTRUCTOR);
        } else {
            for (JavadocLinkGenerator.JavadocToolVersionRange potentialVersion : VERSIONS_PER_TYPE.get((Object)memberType)) {
                fragment = JavadocSite.getFragmentForMember(potentialVersion, member, memberType == FullyQualifiedJavadocReference.MemberType.CONSTRUCTOR);
                if (!this.findAnchor(url, fragment)) continue;
                if (memberType != FullyQualifiedJavadocReference.MemberType.CONSTRUCTOR && memberType != FullyQualifiedJavadocReference.MemberType.METHOD) break;
                this.version = potentialVersion;
                break;
            }
        }
        return new URI(url.getScheme(), url.getSchemeSpecificPart(), fragment);
    }

    static String getFragmentForMember(JavadocLinkGenerator.JavadocToolVersionRange version, String member, boolean isConstructor) {
        String fragment = member;
        switch (version) {
            case JDK7_OR_LOWER: {
                fragment = fragment.replace(",", ", ");
                break;
            }
            case JDK8_OR_9: {
                fragment = fragment.replace("[]", ":A");
                fragment = fragment.replace('(', '-').replace(')', '-').replace(',', '-');
                break;
            }
            case JDK10_OR_HIGHER: {
                if (!isConstructor) break;
                int indexOfOpeningParenthesis = fragment.indexOf(40);
                if (indexOfOpeningParenthesis >= 0) {
                    fragment = "&lt;init&gt;" + fragment.substring(indexOfOpeningParenthesis);
                    break;
                }
                fragment = "&lt;init&gt;";
                break;
            }
            default: {
                throw new IllegalArgumentException("No valid version range given");
            }
        }
        return fragment;
    }

    boolean findAnchor(URI uri, String anchorNameOrId) throws MalformedURLException, IOException {
        return JavadocSite.findLineContaining(uri, this.settings, JavadocSite.getAnchorPattern(anchorNameOrId));
    }

    static Pattern getAnchorPattern(String anchorNameOrId) {
        return Pattern.compile(".*(name|NAME|id)=\\\"" + Pattern.quote(anchorNameOrId) + "\\\"");
    }

    private static CloseableHttpClient createHttpClient(Settings settings, URL url) {
        HttpClientBuilder builder = HttpClients.custom();
        Registry csfRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSystemSocketFactory()).build();
        builder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(csfRegistry));
        builder.setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(2000).setConnectTimeout(2000).setCircularRedirectsAllowed(true).setCookieSpec("ignoreCookies").build());
        builder.setUserAgent("Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
        builder.setDefaultHeaders(Arrays.asList(new BasicHeader("Accept", "*/*")));
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy activeProxy = settings.getActiveProxy();
            ProxyInfo proxyInfo = new ProxyInfo();
            proxyInfo.setNonProxyHosts(activeProxy.getNonProxyHosts());
            if (StringUtils.isNotEmpty((String)activeProxy.getHost()) && (url == null || !ProxyUtils.validateNonProxyHosts((ProxyInfo)proxyInfo, (String)url.getHost()))) {
                HttpHost proxy = new HttpHost(activeProxy.getHost(), activeProxy.getPort());
                builder.setProxy(proxy);
                if (StringUtils.isNotEmpty((String)activeProxy.getUsername()) && activeProxy.getPassword() != null) {
                    UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(activeProxy.getUsername(), activeProxy.getPassword());
                    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                    credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
                }
            }
        }
        return builder.build();
    }

    static BufferedReader getReader(URL url, Settings settings) throws IOException {
        BufferedReader reader = null;
        if ("file".equals(url.getProtocol())) {
            reader = new BufferedReader(new InputStreamReader(url.openStream()));
        } else {
            CloseableHttpResponse response;
            final CloseableHttpClient httpClient = JavadocSite.createHttpClient(settings, url);
            final HttpGet httpMethod = new HttpGet(url.toString());
            HttpClientContext httpContext = HttpClientContext.create();
            try {
                response = httpClient.execute((HttpUriRequest)httpMethod, (HttpContext)httpContext);
            }
            catch (SocketTimeoutException e) {
                response = httpClient.execute((HttpUriRequest)httpMethod, (HttpContext)httpContext);
            }
            int status = response.getStatusLine().getStatusCode();
            if (status != 200) {
                throw new FileNotFoundException("Unexpected HTTP status code " + status + " getting resource " + url.toExternalForm() + ".");
            }
            int pos = url.getPath().lastIndexOf(47);
            List redirects = httpContext.getRedirectLocations();
            if (pos >= 0 && JavadocSite.isNotEmpty(redirects)) {
                URI location = (URI)redirects.get(redirects.size() - 1);
                String suffix = url.getPath().substring(pos);
                if (!location.getPath().endsWith(suffix)) {
                    throw new FileNotFoundException(url.toExternalForm() + " redirects to " + location.toURL().toExternalForm() + ".");
                }
            }
            reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent())){

                @Override
                public void close() throws IOException {
                    super.close();
                    if (httpMethod != null) {
                        httpMethod.releaseConnection();
                    }
                    if (httpClient != null) {
                        httpClient.close();
                    }
                }
            };
        }
        return reader;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    static {
        VERSIONS_PER_TYPE.put(FullyQualifiedJavadocReference.MemberType.CONSTRUCTOR, EnumSet.of(JavadocLinkGenerator.JavadocToolVersionRange.JDK7_OR_LOWER, JavadocLinkGenerator.JavadocToolVersionRange.JDK8_OR_9, JavadocLinkGenerator.JavadocToolVersionRange.JDK10_OR_HIGHER));
        VERSIONS_PER_TYPE.put(FullyQualifiedJavadocReference.MemberType.METHOD, EnumSet.of(JavadocLinkGenerator.JavadocToolVersionRange.JDK7_OR_LOWER, JavadocLinkGenerator.JavadocToolVersionRange.JDK8_OR_9, JavadocLinkGenerator.JavadocToolVersionRange.JDK10_OR_HIGHER));
        VERSIONS_PER_TYPE.put(FullyQualifiedJavadocReference.MemberType.FIELD, EnumSet.of(JavadocLinkGenerator.JavadocToolVersionRange.JDK7_OR_LOWER, JavadocLinkGenerator.JavadocToolVersionRange.JDK8_OR_9));
    }
}

