/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.scanner;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.descriptor.InvalidPluginDescriptorException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.tools.plugin.DefaultPluginToolsRequest;
import org.apache.maven.tools.plugin.PluginToolsRequest;
import org.apache.maven.tools.plugin.extractor.ExtractionException;
import org.apache.maven.tools.plugin.extractor.MojoDescriptorExtractor;
import org.apache.maven.tools.plugin.scanner.MojoScanner;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMojoScanner
extends AbstractLogEnabled
implements MojoScanner {
    private Map<String, MojoDescriptorExtractor> mojoDescriptorExtractors;
    private Set<String> activeExtractors;

    public DefaultMojoScanner(Map<String, MojoDescriptorExtractor> extractors) {
        this.mojoDescriptorExtractors = extractors;
        this.enableLogging((Logger)new ConsoleLogger(1, "standalone-scanner-logger"));
    }

    public DefaultMojoScanner() {
    }

    @Override
    public void populatePluginDescriptor(MavenProject project, PluginDescriptor pluginDescriptor) throws ExtractionException, InvalidPluginDescriptorException {
        this.populatePluginDescriptor(new DefaultPluginToolsRequest(project, pluginDescriptor));
    }

    @Override
    public void populatePluginDescriptor(PluginToolsRequest request) throws ExtractionException, InvalidPluginDescriptorException {
        Logger logger = this.getLogger();
        Set<String> activeExtractorsInternal = this.getActiveExtractors();
        logger.debug("Using " + activeExtractorsInternal.size() + " mojo extractors.");
        int numMojoDescriptors = 0;
        for (String language : activeExtractorsInternal) {
            MojoDescriptorExtractor extractor = this.mojoDescriptorExtractors.get(language);
            if (extractor == null) {
                throw new ExtractionException("No mojo extractor for language: " + language);
            }
            logger.info("Applying mojo extractor for language: " + language);
            List<MojoDescriptor> extractorDescriptors = extractor.execute(request);
            logger.info("Mojo extractor for language: " + language + " found " + extractorDescriptors.size() + " mojo descriptors.");
            numMojoDescriptors += extractorDescriptors.size();
            for (MojoDescriptor descriptor : extractorDescriptors) {
                logger.debug("Adding mojo: " + descriptor + " to plugin descriptor.");
                descriptor.setPluginDescriptor(request.getPluginDescriptor());
                request.getPluginDescriptor().addMojo(descriptor);
            }
        }
        if (numMojoDescriptors == 0 && !request.isSkipErrorNoDescriptorsFound()) {
            throw new InvalidPluginDescriptorException("No mojo definitions were found for plugin: " + request.getPluginDescriptor().getPluginLookupKey() + ".");
        }
    }

    protected Set<String> getActiveExtractors() {
        Set<String> result = this.activeExtractors;
        if (result == null) {
            result = new HashSet<String>(this.mojoDescriptorExtractors.keySet());
        }
        return result;
    }

    @Override
    public void setActiveExtractors(Set<String> extractors) {
        if (extractors == null) {
            this.activeExtractors = null;
        } else {
            this.activeExtractors = new HashSet<String>();
            for (String extractor : extractors) {
                if (!StringUtils.isNotEmpty((String)extractor)) continue;
                this.activeExtractors.add(extractor);
            }
        }
    }
}

