/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.tools.easymock;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;

public class TestFileManager {
    public static final String TEMP_DIR_PATH = System.getProperty("java.io.tmpdir");
    private List filesToDelete = new ArrayList();
    private final String baseFilename;
    private final String fileSuffix;
    private StackTraceElement callerInfo;
    private Thread cleanupWarning;
    private boolean warnAboutCleanup = false;

    public TestFileManager(String baseFilename, String fileSuffix) {
        this.baseFilename = baseFilename;
        this.fileSuffix = fileSuffix;
        this.initializeCleanupMonitoring();
    }

    private void initializeCleanupMonitoring() {
        this.callerInfo = new NullPointerException().getStackTrace()[2];
        Runnable warning = new Runnable(){

            public void run() {
                TestFileManager.this.maybeWarnAboutCleanUp();
            }
        };
        this.cleanupWarning = new Thread(warning);
        Runtime.getRuntime().addShutdownHook(this.cleanupWarning);
    }

    protected void maybeWarnAboutCleanUp() {
        if (this.warnAboutCleanup) {
            System.out.println("[WARNING] TestFileManager from: " + this.callerInfo.getClassName() + " not cleaned up!");
        }
    }

    public void markForDeletion(File toDelete) {
        this.filesToDelete.add(toDelete);
        this.warnAboutCleanup = true;
    }

    public synchronized File createTempDir() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        File dir = new File(TEMP_DIR_PATH, this.baseFilename + System.currentTimeMillis());
        dir.mkdirs();
        this.markForDeletion(dir);
        return dir;
    }

    public synchronized File createTempFile() throws IOException {
        File tempFile = File.createTempFile(this.baseFilename, this.fileSuffix);
        tempFile.deleteOnExit();
        this.markForDeletion(tempFile);
        return tempFile;
    }

    public void cleanUp() throws IOException {
        Iterator it = this.filesToDelete.iterator();
        while (it.hasNext()) {
            File file = (File)it.next();
            if (file.exists()) {
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory((File)file);
                } else {
                    file.delete();
                }
            }
            it.remove();
        }
        this.warnAboutCleanup = false;
    }

    public void assertFileExistence(File dir, String filename, boolean shouldExist) {
        File file = new File(dir, filename);
        if (shouldExist) {
            Assert.assertTrue((boolean)file.exists());
        } else {
            Assert.assertFalse((boolean)file.exists());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertFileContents(File dir, String filename, String contentsTest) throws IOException {
        this.assertFileExistence(dir, filename, true);
        File file = new File(dir, filename);
        FileReader reader = null;
        StringWriter writer = new StringWriter();
        try {
            reader = new FileReader(file);
            IOUtil.copy((Reader)reader, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        Assert.assertEquals((String)contentsTest, (String)writer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createFile(File dir, String filename, String contents) throws IOException {
        File file = new File(dir, filename);
        file.getParentFile().mkdirs();
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            IOUtil.copy((Reader)new StringReader(contents), (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtil.close(writer);
            throw throwable;
        }
        IOUtil.close((Writer)writer);
        this.markForDeletion(file);
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFileContents(File file) throws IOException {
        String result = null;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            StringWriter writer = new StringWriter();
            IOUtil.copy((Reader)reader, (Writer)writer);
            result = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Reader)reader);
        return result;
    }

    protected void finalize() throws Throwable {
        this.maybeWarnAboutCleanUp();
        super.finalize();
    }

    public File createFile(String filename, String content) throws IOException {
        File dir = this.createTempDir();
        return this.createFile(dir, filename, content);
    }
}

