/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class RepositoryPolicy
implements Serializable,
InputLocationTracker {
    final String enabled;
    final String updatePolicy;
    final String checksumPolicy;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected RepositoryPolicy(Builder builder) {
        String string = builder.enabled != null ? builder.enabled : (this.enabled = builder.base != null ? builder.base.enabled : null);
        String string2 = builder.updatePolicy != null ? builder.updatePolicy : (this.updatePolicy = builder.base != null ? builder.base.updatePolicy : null);
        this.checksumPolicy = builder.checksumPolicy != null ? builder.checksumPolicy : (builder.base != null ? builder.base.checksumPolicy : null);
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("enabled", newlocs.containsKey("enabled") ? (InputLocation)newlocs.get("enabled") : (InputLocation)oldlocs.get("enabled"));
        mutableLocations.put("updatePolicy", newlocs.containsKey("updatePolicy") ? (InputLocation)newlocs.get("updatePolicy") : (InputLocation)oldlocs.get("updatePolicy"));
        mutableLocations.put("checksumPolicy", newlocs.containsKey("checksumPolicy") ? (InputLocation)newlocs.get("checksumPolicy") : (InputLocation)oldlocs.get("checksumPolicy"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getEnabled() {
        return this.enabled;
    }

    public String getUpdatePolicy() {
        return this.updatePolicy;
    }

    public String getChecksumPolicy() {
        return this.checksumPolicy;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return RepositoryPolicy.newBuilder(this);
    }

    @Nonnull
    public RepositoryPolicy withEnabled(String enabled) {
        return RepositoryPolicy.newBuilder(this, true).enabled(enabled).build();
    }

    @Nonnull
    public RepositoryPolicy withUpdatePolicy(String updatePolicy) {
        return RepositoryPolicy.newBuilder(this, true).updatePolicy(updatePolicy).build();
    }

    @Nonnull
    public RepositoryPolicy withChecksumPolicy(String checksumPolicy) {
        return RepositoryPolicy.newBuilder(this, true).checksumPolicy(checksumPolicy).build();
    }

    @Nonnull
    public static RepositoryPolicy newInstance() {
        return RepositoryPolicy.newInstance(true);
    }

    @Nonnull
    public static RepositoryPolicy newInstance(boolean withDefaults) {
        return RepositoryPolicy.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return RepositoryPolicy.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from) {
        return RepositoryPolicy.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(RepositoryPolicy from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isEnabled() {
        return this.getEnabled() != null ? Boolean.parseBoolean(this.getEnabled()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        RepositoryPolicy base;
        String enabled;
        String updatePolicy;
        String checksumPolicy;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(RepositoryPolicy base, boolean forceCopy) {
            if (forceCopy) {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy(String updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy(String checksumPolicy) {
            this.checksumPolicy = checksumPolicy;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public RepositoryPolicy build() {
            if (!(this.base == null || this.enabled != null && this.enabled != this.base.enabled || this.updatePolicy != null && this.updatePolicy != this.base.updatePolicy || this.checksumPolicy != null && this.checksumPolicy != this.base.checksumPolicy)) {
                return this.base;
            }
            return new RepositoryPolicy(this);
        }
    }
}

