/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.PatternSet;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class FileSet
extends PatternSet
implements Serializable,
InputLocationTracker {
    final String directory;
    final Map<Object, InputLocation> locations;

    protected FileSet(Builder builder) {
        super(builder);
        this.directory = builder.directory != null ? builder.directory : (builder.base != null ? builder.base.directory : null);
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((PatternSet)this).locations);
        mutableLocations.put("directory", newlocs.containsKey("directory") ? (InputLocation)newlocs.get("directory") : (InputLocation)oldlocs.get("directory"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getDirectory() {
        return this.directory;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return FileSet.newBuilder(this);
    }

    @Override
    @Nonnull
    public FileSet withIncludes(Collection<String> includes) {
        return ((Builder)FileSet.newBuilder(this, true).includes((Collection)includes)).build();
    }

    @Override
    @Nonnull
    public FileSet withExcludes(Collection<String> excludes) {
        return ((Builder)FileSet.newBuilder(this, true).excludes((Collection)excludes)).build();
    }

    @Nonnull
    public FileSet withDirectory(String directory) {
        return FileSet.newBuilder(this, true).directory(directory).build();
    }

    @Nonnull
    public static FileSet newInstance() {
        return FileSet.newInstance(true);
    }

    @Nonnull
    public static FileSet newInstance(boolean withDefaults) {
        return FileSet.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return FileSet.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(FileSet from) {
        return FileSet.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(FileSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "FileSet {directory: " + this.getDirectory() + ", " + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends PatternSet.Builder {
        FileSet base;
        String directory;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(FileSet base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.directory = base.directory;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder includes(Collection<String> includes) {
            this.includes = includes;
            return this;
        }

        @Override
        @Nonnull
        public Builder excludes(Collection<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public FileSet build() {
            if (!(this.base == null || this.includes != null && this.includes != this.base.includes || this.excludes != null && this.excludes != this.base.excludes || this.directory != null && this.directory != this.base.directory)) {
                return this.base;
            }
            return new FileSet(this);
        }
    }
}

