/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.BuildBase;
import org.apache.maven.api.model.Extension;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Plugin;
import org.apache.maven.api.model.PluginManagement;
import org.apache.maven.api.model.Resource;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Build
extends BuildBase
implements Serializable,
InputLocationTracker {
    final String sourceDirectory;
    final String scriptSourceDirectory;
    final String testSourceDirectory;
    final String outputDirectory;
    final String testOutputDirectory;
    final List<Extension> extensions;
    final Map<Object, InputLocation> locations;

    protected Build(Builder builder) {
        super(builder);
        String string = builder.sourceDirectory != null ? builder.sourceDirectory : (this.sourceDirectory = builder.base != null ? builder.base.sourceDirectory : null);
        String string2 = builder.scriptSourceDirectory != null ? builder.scriptSourceDirectory : (this.scriptSourceDirectory = builder.base != null ? builder.base.scriptSourceDirectory : null);
        String string3 = builder.testSourceDirectory != null ? builder.testSourceDirectory : (this.testSourceDirectory = builder.base != null ? builder.base.testSourceDirectory : null);
        String string4 = builder.outputDirectory != null ? builder.outputDirectory : (this.outputDirectory = builder.base != null ? builder.base.outputDirectory : null);
        String string5 = builder.testOutputDirectory != null ? builder.testOutputDirectory : (this.testOutputDirectory = builder.base != null ? builder.base.testOutputDirectory : null);
        this.extensions = ImmutableCollections.copy(builder.extensions != null ? builder.extensions : (builder.base != null ? builder.base.extensions : null));
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((BuildBase)this).locations);
        mutableLocations.put("sourceDirectory", newlocs.containsKey("sourceDirectory") ? (InputLocation)newlocs.get("sourceDirectory") : (InputLocation)oldlocs.get("sourceDirectory"));
        mutableLocations.put("scriptSourceDirectory", newlocs.containsKey("scriptSourceDirectory") ? (InputLocation)newlocs.get("scriptSourceDirectory") : (InputLocation)oldlocs.get("scriptSourceDirectory"));
        mutableLocations.put("testSourceDirectory", newlocs.containsKey("testSourceDirectory") ? (InputLocation)newlocs.get("testSourceDirectory") : (InputLocation)oldlocs.get("testSourceDirectory"));
        mutableLocations.put("outputDirectory", newlocs.containsKey("outputDirectory") ? (InputLocation)newlocs.get("outputDirectory") : (InputLocation)oldlocs.get("outputDirectory"));
        mutableLocations.put("testOutputDirectory", newlocs.containsKey("testOutputDirectory") ? (InputLocation)newlocs.get("testOutputDirectory") : (InputLocation)oldlocs.get("testOutputDirectory"));
        mutableLocations.put("extensions", newlocs.containsKey("extensions") ? (InputLocation)newlocs.get("extensions") : (InputLocation)oldlocs.get("extensions"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getSourceDirectory() {
        return this.sourceDirectory;
    }

    public String getScriptSourceDirectory() {
        return this.scriptSourceDirectory;
    }

    public String getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getTestOutputDirectory() {
        return this.testOutputDirectory;
    }

    @Nonnull
    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return Build.newBuilder(this);
    }

    @Override
    @Nonnull
    public Build withPlugins(Collection<Plugin> plugins) {
        return ((Builder)Build.newBuilder(this, true).plugins((Collection)plugins)).build();
    }

    @Override
    @Nonnull
    public Build withPluginManagement(PluginManagement pluginManagement) {
        return Build.newBuilder(this, true).pluginManagement(pluginManagement).build();
    }

    @Override
    @Nonnull
    public Build withDefaultGoal(String defaultGoal) {
        return Build.newBuilder(this, true).defaultGoal(defaultGoal).build();
    }

    @Override
    @Nonnull
    public Build withResources(Collection<Resource> resources) {
        return ((Builder)Build.newBuilder(this, true).resources((Collection)resources)).build();
    }

    @Override
    @Nonnull
    public Build withTestResources(Collection<Resource> testResources) {
        return ((Builder)Build.newBuilder(this, true).testResources((Collection)testResources)).build();
    }

    @Override
    @Nonnull
    public Build withDirectory(String directory) {
        return Build.newBuilder(this, true).directory(directory).build();
    }

    @Override
    @Nonnull
    public Build withFinalName(String finalName) {
        return Build.newBuilder(this, true).finalName(finalName).build();
    }

    @Override
    @Nonnull
    public Build withFilters(Collection<String> filters) {
        return ((Builder)Build.newBuilder(this, true).filters((Collection)filters)).build();
    }

    @Nonnull
    public Build withSourceDirectory(String sourceDirectory) {
        return Build.newBuilder(this, true).sourceDirectory(sourceDirectory).build();
    }

    @Nonnull
    public Build withScriptSourceDirectory(String scriptSourceDirectory) {
        return Build.newBuilder(this, true).scriptSourceDirectory(scriptSourceDirectory).build();
    }

    @Nonnull
    public Build withTestSourceDirectory(String testSourceDirectory) {
        return Build.newBuilder(this, true).testSourceDirectory(testSourceDirectory).build();
    }

    @Nonnull
    public Build withOutputDirectory(String outputDirectory) {
        return Build.newBuilder(this, true).outputDirectory(outputDirectory).build();
    }

    @Nonnull
    public Build withTestOutputDirectory(String testOutputDirectory) {
        return Build.newBuilder(this, true).testOutputDirectory(testOutputDirectory).build();
    }

    @Nonnull
    public Build withExtensions(Collection<Extension> extensions) {
        return Build.newBuilder(this, true).extensions(extensions).build();
    }

    @Nonnull
    public static Build newInstance() {
        return Build.newInstance(true);
    }

    @Nonnull
    public static Build newInstance(boolean withDefaults) {
        return Build.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Build.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Build from) {
        return Build.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Build from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @Override
    public String toString() {
        return "Build {" + super.toString() + "}";
    }

    @NotThreadSafe
    public static class Builder
    extends BuildBase.Builder {
        Build base;
        String sourceDirectory;
        String scriptSourceDirectory;
        String testSourceDirectory;
        String outputDirectory;
        String testOutputDirectory;
        Collection<Extension> extensions;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Build base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.sourceDirectory = base.sourceDirectory;
                this.scriptSourceDirectory = base.scriptSourceDirectory;
                this.testSourceDirectory = base.testSourceDirectory;
                this.outputDirectory = base.outputDirectory;
                this.testOutputDirectory = base.testOutputDirectory;
                this.extensions = base.extensions;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Override
        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }

        @Override
        @Nonnull
        public Builder defaultGoal(String defaultGoal) {
            this.defaultGoal = defaultGoal;
            return this;
        }

        @Override
        @Nonnull
        public Builder resources(Collection<Resource> resources) {
            this.resources = resources;
            return this;
        }

        @Override
        @Nonnull
        public Builder testResources(Collection<Resource> testResources) {
            this.testResources = testResources;
            return this;
        }

        @Override
        @Nonnull
        public Builder directory(String directory) {
            this.directory = directory;
            return this;
        }

        @Override
        @Nonnull
        public Builder finalName(String finalName) {
            this.finalName = finalName;
            return this;
        }

        @Override
        @Nonnull
        public Builder filters(Collection<String> filters) {
            this.filters = filters;
            return this;
        }

        @Nonnull
        public Builder sourceDirectory(String sourceDirectory) {
            this.sourceDirectory = sourceDirectory;
            return this;
        }

        @Nonnull
        public Builder scriptSourceDirectory(String scriptSourceDirectory) {
            this.scriptSourceDirectory = scriptSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder testSourceDirectory(String testSourceDirectory) {
            this.testSourceDirectory = testSourceDirectory;
            return this;
        }

        @Nonnull
        public Builder outputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder testOutputDirectory(String testOutputDirectory) {
            this.testOutputDirectory = testOutputDirectory;
            return this;
        }

        @Nonnull
        public Builder extensions(Collection<Extension> extensions) {
            this.extensions = extensions;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public Build build() {
            if (!(this.base == null || this.plugins != null && this.plugins != this.base.plugins || this.pluginManagement != null && this.pluginManagement != this.base.pluginManagement || this.defaultGoal != null && this.defaultGoal != this.base.defaultGoal || this.resources != null && this.resources != this.base.resources || this.testResources != null && this.testResources != this.base.testResources || this.directory != null && this.directory != this.base.directory || this.finalName != null && this.finalName != this.base.finalName || this.filters != null && this.filters != this.base.filters || this.sourceDirectory != null && this.sourceDirectory != this.base.sourceDirectory || this.scriptSourceDirectory != null && this.scriptSourceDirectory != this.base.scriptSourceDirectory || this.testSourceDirectory != null && this.testSourceDirectory != this.base.testSourceDirectory || this.outputDirectory != null && this.outputDirectory != this.base.outputDirectory || this.testOutputDirectory != null && this.testOutputDirectory != this.base.testOutputDirectory || this.extensions != null && this.extensions != this.base.extensions)) {
                return this.base;
            }
            return new Build(this);
        }
    }
}

