// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;

/**
 * Represents a set of reports and configuration to be used to generate them.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ReportSet
    extends ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The unique id for this report set, to be used during POM inheritance and profile injection
     * for merging of report sets.
     */
    final String id;
    /**
     * The list of reports from this plugin which should be generated from this set.
     */
    final List<String> reports;
    /** Location of the xml element for the field id. */
    final InputLocation idLocation;
    /** Location of the xml element for the field reports. */
    final InputLocation reportsLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ReportSet(
        String inherited,
        Dom configuration,
        String id,
        Collection<String> reports,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation inheritedLocation,
        InputLocation configurationLocation,
        InputLocation idLocation,
        InputLocation reportsLocation
    )
    {
        super(
            inherited,
            configuration,
            locations,
            location,
            inheritedLocation,
            configurationLocation
        );
        this.id = id;
        this.reports = ImmutableCollections.copy( reports );
        this.idLocation = idLocation;
        this.reportsLocation = reportsLocation;
    }

    /**
     * The unique id for this report set, to be used during POM inheritance and profile injection
     * for merging of report sets.
     *
     * @return a {@code String}
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * The list of reports from this plugin which should be generated from this set.
     *
     * @return a {@code List<String>}
     */
    @Nonnull
    public List<String> getReports()
    {
        return this.reports;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "id":
                    return idLocation;
                case "reports":
                    return reportsLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code ReportSet} with the specified inherited
     */
    @Nonnull
    public ReportSet withInherited( String inherited )
    {
        return with().inherited( inherited ).build();
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified configuration.
     *
     * @param configuration the new {@code Dom} to use
     * @return a {@code ReportSet} with the specified configuration
     */
    @Nonnull
    public ReportSet withConfiguration( Dom configuration )
    {
        return with().configuration( configuration ).build();
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code ReportSet} with the specified id
     */
    @Nonnull
    public ReportSet withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code ReportSet} instance using the specified reports.
     *
     * @param reports the new {@code Collection<String>} to use
     * @return a {@code ReportSet} with the specified reports
     */
    @Nonnull
    public ReportSet withReports( Collection<String> reports )
    {
        return with().reports( reports ).build();
    }

    /**
     * Creates a new {@code ReportSet} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ReportSet}
     */
    @Nonnull
    public static ReportSet newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ReportSet} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ReportSet}
     */
    @Nonnull
    public static ReportSet newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ReportSet} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ReportSet} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ReportSet} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ReportSet} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ReportSet from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ReportSet} builder instance using the specified object as a basis.
     *
     * @param from the {@code ReportSet} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ReportSet from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ReportSet instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ConfigurationContainer.Builder
    {
        ReportSet base;
        String id;
        Collection<String> reports;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.id = "default";
            }
        }

        Builder( ReportSet base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.id = base.id;
                this.reports = base.reports;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited( String inherited )
        {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration( Dom configuration )
        {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder reports( Collection<String> reports )
        {
            this.reports = reports;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ReportSet build()
        {
            if ( base != null
                    && ( inherited == null || inherited == base.inherited )
                    && ( configuration == null || configuration == base.configuration )
                    && ( id == null || id == base.id )
                    && ( reports == null || reports == base.reports )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation idLocation = null;
            InputLocation reportsLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                inheritedLocation = locations.remove( "inherited" );
                configurationLocation = locations.remove( "configuration" );
                idLocation = locations.remove( "id" );
                reportsLocation = locations.remove( "reports" );
            }
            return new ReportSet(
                inherited != null ? inherited : ( base != null ? base.inherited : null ),
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                id != null ? id : ( base != null ? base.id : null ),
                reports != null ? reports : ( base != null ? base.reports : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                inheritedLocation != null ? inheritedLocation : ( base != null ? base.inheritedLocation : null ),
                configurationLocation != null ? configurationLocation : ( base != null ? base.configurationLocation : null ),
                idLocation != null ? idLocation : ( base != null ? base.idLocation : null ),
                reportsLocation != null ? reportsLocation : ( base != null ? base.reportsLocation : null )
            );
        }
    }


            
    @Override
    public String toString()
    {
        return getId();
    }
            
          
}
