// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;

/**
 * The {@code <plugin>} element contains informations required for a plugin.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Plugin
    extends ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The group ID of the plugin in the repository.
     */
    final String groupId;
    /**
     * The artifact ID of the plugin in the repository.
     */
    final String artifactId;
    /**
     * The version (or valid range of versions) of the plugin to be used.
     */
    final String version;
    /**
     * Whether to load Maven extensions (such as packaging and type handlers) from
     * this plugin. For performance reasons, this should only be enabled when necessary. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     */
    final String extensions;
    /**
     * Multiple specifications of a set of goals to execute during the build
     * lifecycle, each having (possibly) a different configuration.
     */
    final List<PluginExecution> executions;
    /**
     * Additional dependencies that this project needs to introduce to the plugin's
     * classloader.
     */
    final List<Dependency> dependencies;
    /** Location of the xml element for the field groupId. */
    final InputLocation groupIdLocation;
    /** Location of the xml element for the field artifactId. */
    final InputLocation artifactIdLocation;
    /** Location of the xml element for the field version. */
    final InputLocation versionLocation;
    /** Location of the xml element for the field extensions. */
    final InputLocation extensionsLocation;
    /** Location of the xml element for the field executions. */
    final InputLocation executionsLocation;
    /** Location of the xml element for the field dependencies. */
    final InputLocation dependenciesLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Plugin(
        String inherited,
        Dom configuration,
        String groupId,
        String artifactId,
        String version,
        String extensions,
        Collection<PluginExecution> executions,
        Collection<Dependency> dependencies,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation inheritedLocation,
        InputLocation configurationLocation,
        InputLocation groupIdLocation,
        InputLocation artifactIdLocation,
        InputLocation versionLocation,
        InputLocation extensionsLocation,
        InputLocation executionsLocation,
        InputLocation dependenciesLocation
    )
    {
        super(
            inherited,
            configuration,
            locations,
            location,
            inheritedLocation,
            configurationLocation
        );
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.extensions = extensions;
        this.executions = ImmutableCollections.copy( executions );
        this.dependencies = ImmutableCollections.copy( dependencies );
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.extensionsLocation = extensionsLocation;
        this.executionsLocation = executionsLocation;
        this.dependenciesLocation = dependenciesLocation;
    }

    /**
     * The group ID of the plugin in the repository.
     *
     * @return a {@code String}
     */
    public String getGroupId()
    {
        return this.groupId;
    }

    /**
     * The artifact ID of the plugin in the repository.
     *
     * @return a {@code String}
     */
    public String getArtifactId()
    {
        return this.artifactId;
    }

    /**
     * The version (or valid range of versions) of the plugin to be used.
     *
     * @return a {@code String}
     */
    public String getVersion()
    {
        return this.version;
    }

    /**
     * Whether to load Maven extensions (such as packaging and type handlers) from
     * this plugin. For performance reasons, this should only be enabled when necessary. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     *
     * @return a {@code String}
     */
    public String getExtensions()
    {
        return this.extensions;
    }

    /**
     * Multiple specifications of a set of goals to execute during the build
     * lifecycle, each having (possibly) a different configuration.
     *
     * @return a {@code List<PluginExecution>}
     */
    @Nonnull
    public List<PluginExecution> getExecutions()
    {
        return this.executions;
    }

    /**
     * Additional dependencies that this project needs to introduce to the plugin's
     * classloader.
     *
     * @return a {@code List<Dependency>}
     */
    @Nonnull
    public List<Dependency> getDependencies()
    {
        return this.dependencies;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "groupId":
                    return groupIdLocation;
                case "artifactId":
                    return artifactIdLocation;
                case "version":
                    return versionLocation;
                case "extensions":
                    return extensionsLocation;
                case "executions":
                    return executionsLocation;
                case "dependencies":
                    return dependenciesLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Plugin} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code Plugin} with the specified inherited
     */
    @Nonnull
    public Plugin withInherited( String inherited )
    {
        return with().inherited( inherited ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified configuration.
     *
     * @param configuration the new {@code Dom} to use
     * @return a {@code Plugin} with the specified configuration
     */
    @Nonnull
    public Plugin withConfiguration( Dom configuration )
    {
        return with().configuration( configuration ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Plugin} with the specified groupId
     */
    @Nonnull
    public Plugin withGroupId( String groupId )
    {
        return with().groupId( groupId ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Plugin} with the specified artifactId
     */
    @Nonnull
    public Plugin withArtifactId( String artifactId )
    {
        return with().artifactId( artifactId ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Plugin} with the specified version
     */
    @Nonnull
    public Plugin withVersion( String version )
    {
        return with().version( version ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified extensions.
     *
     * @param extensions the new {@code String} to use
     * @return a {@code Plugin} with the specified extensions
     */
    @Nonnull
    public Plugin withExtensions( String extensions )
    {
        return with().extensions( extensions ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified executions.
     *
     * @param executions the new {@code Collection<PluginExecution>} to use
     * @return a {@code Plugin} with the specified executions
     */
    @Nonnull
    public Plugin withExecutions( Collection<PluginExecution> executions )
    {
        return with().executions( executions ).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code Plugin} with the specified dependencies
     */
    @Nonnull
    public Plugin withDependencies( Collection<Dependency> dependencies )
    {
        return with().dependencies( dependencies ).build();
    }

    /**
     * Creates a new {@code Plugin} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Plugin}
     */
    @Nonnull
    public static Plugin newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Plugin} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Plugin}
     */
    @Nonnull
    public static Plugin newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Plugin} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Plugin} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Plugin} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Plugin} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Plugin from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Plugin} builder instance using the specified object as a basis.
     *
     * @param from the {@code Plugin} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Plugin from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Plugin instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ConfigurationContainer.Builder
    {
        Plugin base;
        String groupId;
        String artifactId;
        String version;
        String extensions;
        Collection<PluginExecution> executions;
        Collection<Dependency> dependencies;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        Builder( Plugin base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.extensions = base.extensions;
                this.executions = base.executions;
                this.dependencies = base.dependencies;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited( String inherited )
        {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration( Dom configuration )
        {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId( String groupId )
        {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId( String artifactId )
        {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version( String version )
        {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder extensions( String extensions )
        {
            this.extensions = extensions;
            return this;
        }

        @Nonnull
        public Builder executions( Collection<PluginExecution> executions )
        {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder dependencies( Collection<Dependency> dependencies )
        {
            this.dependencies = dependencies;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Plugin build()
        {
            if ( base != null
                    && ( inherited == null || inherited == base.inherited )
                    && ( configuration == null || configuration == base.configuration )
                    && ( groupId == null || groupId == base.groupId )
                    && ( artifactId == null || artifactId == base.artifactId )
                    && ( version == null || version == base.version )
                    && ( extensions == null || extensions == base.extensions )
                    && ( executions == null || executions == base.executions )
                    && ( dependencies == null || dependencies == base.dependencies )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation extensionsLocation = null;
            InputLocation executionsLocation = null;
            InputLocation dependenciesLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                inheritedLocation = locations.remove( "inherited" );
                configurationLocation = locations.remove( "configuration" );
                groupIdLocation = locations.remove( "groupId" );
                artifactIdLocation = locations.remove( "artifactId" );
                versionLocation = locations.remove( "version" );
                extensionsLocation = locations.remove( "extensions" );
                executionsLocation = locations.remove( "executions" );
                dependenciesLocation = locations.remove( "dependencies" );
            }
            return new Plugin(
                inherited != null ? inherited : ( base != null ? base.inherited : null ),
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                groupId != null ? groupId : ( base != null ? base.groupId : null ),
                artifactId != null ? artifactId : ( base != null ? base.artifactId : null ),
                version != null ? version : ( base != null ? base.version : null ),
                extensions != null ? extensions : ( base != null ? base.extensions : null ),
                executions != null ? executions : ( base != null ? base.executions : null ),
                dependencies != null ? dependencies : ( base != null ? base.dependencies : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                inheritedLocation != null ? inheritedLocation : ( base != null ? base.inheritedLocation : null ),
                configurationLocation != null ? configurationLocation : ( base != null ? base.configurationLocation : null ),
                groupIdLocation != null ? groupIdLocation : ( base != null ? base.groupIdLocation : null ),
                artifactIdLocation != null ? artifactIdLocation : ( base != null ? base.artifactIdLocation : null ),
                versionLocation != null ? versionLocation : ( base != null ? base.versionLocation : null ),
                extensionsLocation != null ? extensionsLocation : ( base != null ? base.extensionsLocation : null ),
                executionsLocation != null ? executionsLocation : ( base != null ? base.executionsLocation : null ),
                dependenciesLocation != null ? dependenciesLocation : ( base != null ? base.dependenciesLocation : null )
            );
        }
    }


            
    public boolean isExtensions()
    {
        return ( getExtensions() != null ) ? Boolean.parseBoolean( getExtensions() ) : false;
    }
            
          

            
    private java.util.Map<String, PluginExecution> executionMap = null;

    /**
     * Reset the {@code executionMap} field to {@code null}
     */
    public void flushExecutionMap()
    {
        this.executionMap = null;
    }
    /**
     * @return a Map of executions field with {@code PluginExecution#getId()} as key
     * @see PluginExecution#getId()
     */
    public java.util.Map<String, PluginExecution> getExecutionsAsMap()
    {
        if ( executionMap == null )
        {
            executionMap = new java.util.LinkedHashMap<String, PluginExecution>();
            for ( java.util.Iterator<PluginExecution> i = getExecutions().iterator(); i.hasNext(); )
            {
                PluginExecution exec = (PluginExecution) i.next();
                if ( executionMap.containsKey( exec.getId() ) )
                {
                    throw new IllegalStateException( "You cannot have two plugin executions with the same (or missing) <id/> elements.\nOffending execution\n\nId: \'" + exec.getId() + "\'\nPlugin:\'" + getKey() + "\'\n\n" );
                }
                executionMap.put( exec.getId(), exec );
            }
        }
        return executionMap;
    }

    /**
     * Gets the identifier of the plugin.
     *
     * @return The plugin id in the form {@code <groupId>:<artifactId>:<version>}, never {@code null}.
     */
    public String getId()
    {
        StringBuilder id = new StringBuilder( 128 );

        id.append( ( getGroupId() == null ) ? "[unknown-group-id]" : getGroupId() );
        id.append( ":" );
        id.append( ( getArtifactId() == null ) ? "[unknown-artifact-id]" : getArtifactId() );
        id.append( ":" );
        id.append( ( getVersion() == null ) ? "[unknown-version]" : getVersion() );

        return id.toString();
    }

    /**
     * @return the key of the plugin, ie {@code groupId:artifactId}
     */
    public String getKey()
    {
        return constructKey( getGroupId(), getArtifactId() );
    }

    /**
     * @param groupId The group ID of the plugin in the repository
     * @param artifactId The artifact ID of the reporting plugin in the repository
     * @return the key of the plugin, ie {@code groupId:artifactId}
     */
    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object other )
    {
        if ( other instanceof Plugin )
        {
            Plugin otherPlugin = (Plugin) other;

            return getKey().equals( otherPlugin.getKey() );
        }

        return false;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        return getKey().hashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Plugin [" + getKey() + "]";
    }
            
          
}
