/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.index.context.IndexCreator;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.DAG;
import org.codehaus.plexus.util.dag.TopologicalSorter;

public class IndexCreatorSorter {
    public static List<IndexCreator> sort(List<? extends IndexCreator> creators) throws IllegalArgumentException {
        try {
            HashMap<String, IndexCreator> creatorsById = new HashMap<String, IndexCreator>(creators.size());
            DAG dag = new DAG();
            for (IndexCreator indexCreator : creators) {
                creatorsById.put(indexCreator.getId(), indexCreator);
                dag.addVertex(indexCreator.getId());
                for (String depId : indexCreator.getCreatorDependencies()) {
                    dag.addEdge(indexCreator.getId(), depId);
                }
            }
            List<String> sortedIds = TopologicalSorter.sort(dag);
            ArrayList<IndexCreator> arrayList = new ArrayList<IndexCreator>(creators.size());
            for (String id : sortedIds) {
                IndexCreator creator = (IndexCreator)creatorsById.get(id);
                if (creator != null) {
                    arrayList.add(creator);
                    continue;
                }
                throw new IllegalArgumentException(String.format("IndexCreator with ID=\"%s\" does not exists, the present creator ID=\"%s\" depends on it!", id, dag.getParentLabels(id)));
            }
            return arrayList;
        }
        catch (CycleDetectedException e) {
            throw new IllegalArgumentException("Supplied IndexCreator inter-dependencies", e);
        }
    }
}

