/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.OSGI;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named(value="osgi-metadatas")
public class OsgiArtifactIndexCreator
extends AbstractIndexCreator {
    public static final String ID = "osgi-metadatas";
    public static final IndexerField FLD_SHA256 = new IndexerField(OSGI.SHA256, IndexerFieldVersion.V4, "sha256", "SHA-256 (not analyzed, stored)", IndexerField.KEYWORD_STORED);
    private static final String BSN = "Bundle-SymbolicName";
    public static final IndexerField FLD_BUNDLE_SYMBOLIC_NAME = new IndexerField(OSGI.SYMBOLIC_NAME, IndexerFieldVersion.V4, "Bundle-SymbolicName", "Bundle-SymbolicName (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BV = "Bundle-Version";
    public static final IndexerField FLD_BUNDLE_VERSION = new IndexerField(OSGI.VERSION, IndexerFieldVersion.V4, "Bundle-Version", "Bundle-Version (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BEP = "Export-Package";
    public static final IndexerField FLD_BUNDLE_EXPORT_PACKAGE = new IndexerField(OSGI.EXPORT_PACKAGE, IndexerFieldVersion.V4, "Export-Package", "Export-Package (indexed, stored)", IndexerField.ANALYZED_STORED);
    @Deprecated
    private static final String BES = "Export-Service";
    @Deprecated
    public static final IndexerField FLD_BUNDLE_EXPORT_SERVIVE = new IndexerField(OSGI.EXPORT_SERVICE, IndexerFieldVersion.V4, "Export-Service", "Export-Service (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BD = "Bundle-Description";
    public static final IndexerField FLD_BUNDLE_DESCRIPTION = new IndexerField(OSGI.DESCRIPTION, IndexerFieldVersion.V4, "Bundle-Description", "Bundle-Description (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BN = "Bundle-Name";
    public static final IndexerField FLD_BUNDLE_NAME = new IndexerField(OSGI.NAME, IndexerFieldVersion.V4, "Bundle-Name", "Bundle-Name (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BL = "Bundle-License";
    public static final IndexerField FLD_BUNDLE_LICENSE = new IndexerField(OSGI.LICENSE, IndexerFieldVersion.V4, "Bundle-License", "Bundle-License (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BDU = "Bundle-DocURL";
    public static final IndexerField FLD_BUNDLE_DOCURL = new IndexerField(OSGI.DOCURL, IndexerFieldVersion.V4, "Bundle-DocURL", "Bundle-DocURL (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BIP = "Import-Package";
    public static final IndexerField FLD_BUNDLE_IMPORT_PACKAGE = new IndexerField(OSGI.IMPORT_PACKAGE, IndexerFieldVersion.V4, "Import-Package", "Import-Package (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BRB = "Require-Bundle";
    public static final IndexerField FLD_BUNDLE_REQUIRE_BUNDLE = new IndexerField(OSGI.REQUIRE_BUNDLE, IndexerFieldVersion.V4, "Require-Bundle", "Require-Bundle (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String PROVIDE_CAPABILITY = "Provide-Capability";
    public static final IndexerField FLD_BUNDLE_PROVIDE_CAPABILITY = new IndexerField(OSGI.PROVIDE_CAPABILITY, IndexerFieldVersion.V4, "Provide-Capability", "Provide-Capability (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String REQUIRE_CAPABILITY = "Require-Capability";
    public static final IndexerField FLD_BUNDLE_REQUIRE_CAPABILITY = new IndexerField(OSGI.REQUIRE_CAPABILITY, IndexerFieldVersion.V4, "Require-Capability", "Require-Capability (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String FRAGMENT_HOST = "Fragment-Host";
    public static final IndexerField FLD_BUNDLE_FRAGMENT_HOST = new IndexerField(OSGI.FRAGMENT_HOST, IndexerFieldVersion.V4, "Fragment-Host", "Fragment-Host (indexed, stored)", IndexerField.ANALYZED_STORED);
    private static final String BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    public static final IndexerField FLD_BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = new IndexerField(OSGI.BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT, IndexerFieldVersion.V4, "Bundle-RequiredExecutionEnvironment", "Bundle-RequiredExecutionEnvironment (indexed, stored)", IndexerField.ANALYZED_STORED);

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_BUNDLE_SYMBOLIC_NAME, FLD_BUNDLE_VERSION, FLD_BUNDLE_EXPORT_PACKAGE, FLD_BUNDLE_EXPORT_SERVIVE, FLD_BUNDLE_DESCRIPTION, FLD_BUNDLE_NAME, FLD_BUNDLE_LICENSE, FLD_BUNDLE_DOCURL, FLD_BUNDLE_IMPORT_PACKAGE, FLD_BUNDLE_REQUIRE_BUNDLE, FLD_BUNDLE_PROVIDE_CAPABILITY, FLD_BUNDLE_REQUIRE_CAPABILITY, FLD_BUNDLE_FRAGMENT_HOST, FLD_BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT, FLD_SHA256);
    }

    public OsgiArtifactIndexCreator() {
        super(ID);
    }

    @Override
    public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        ArtifactInfo ai = artifactContext.getArtifactInfo();
        File artifactFile = artifactContext.getArtifact();
        if (artifactFile != null && artifactFile.isFile() && artifactFile.getName().endsWith(".jar")) {
            this.updateArtifactInfo(ai, artifactFile);
        }
    }

    @Override
    public void updateDocument(ArtifactInfo artifactInfo, Document document) {
        String bree;
        if (artifactInfo.getBundleSymbolicName() != null) {
            document.add(FLD_BUNDLE_SYMBOLIC_NAME.toField(artifactInfo.getBundleSymbolicName()));
        }
        if (artifactInfo.getBundleVersion() != null) {
            document.add(FLD_BUNDLE_VERSION.toField(artifactInfo.getBundleVersion()));
        }
        if (artifactInfo.getBundleExportPackage() != null) {
            document.add(FLD_BUNDLE_EXPORT_PACKAGE.toField(artifactInfo.getBundleExportPackage()));
        }
        if (artifactInfo.getBundleExportService() != null) {
            document.add(FLD_BUNDLE_EXPORT_SERVIVE.toField(artifactInfo.getBundleExportService()));
        }
        if (artifactInfo.getBundleDescription() != null) {
            document.add(FLD_BUNDLE_DESCRIPTION.toField(artifactInfo.getBundleDescription()));
        }
        if (artifactInfo.getBundleName() != null) {
            document.add(FLD_BUNDLE_NAME.toField(artifactInfo.getBundleName()));
        }
        if (artifactInfo.getBundleLicense() != null) {
            document.add(FLD_BUNDLE_LICENSE.toField(artifactInfo.getBundleLicense()));
        }
        if (artifactInfo.getBundleDocUrl() != null) {
            document.add(FLD_BUNDLE_DOCURL.toField(artifactInfo.getBundleDocUrl()));
        }
        if (artifactInfo.getBundleImportPackage() != null) {
            document.add(FLD_BUNDLE_IMPORT_PACKAGE.toField(artifactInfo.getBundleImportPackage()));
        }
        if (artifactInfo.getBundleRequireBundle() != null) {
            document.add(FLD_BUNDLE_REQUIRE_BUNDLE.toField(artifactInfo.getBundleRequireBundle()));
        }
        if (artifactInfo.getBundleProvideCapability() != null) {
            document.add(FLD_BUNDLE_PROVIDE_CAPABILITY.toField(artifactInfo.getBundleProvideCapability()));
        }
        if (artifactInfo.getBundleRequireCapability() != null) {
            document.add(FLD_BUNDLE_REQUIRE_CAPABILITY.toField(artifactInfo.getBundleRequireCapability()));
        }
        if (artifactInfo.getBundleFragmentHost() != null) {
            document.add(FLD_BUNDLE_FRAGMENT_HOST.toField(artifactInfo.getBundleFragmentHost()));
        }
        if ((bree = artifactInfo.getBundleRequiredExecutionEnvironment()) != null) {
            document.add(FLD_BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT.toField(bree));
        }
        if (artifactInfo.getSha256() != null) {
            document.add(FLD_SHA256.toField(artifactInfo.getSha256()));
        }
    }

    @Override
    public boolean updateArtifactInfo(Document document, ArtifactInfo artifactInfo) {
        String sha256;
        String bundleRequiredExecutionEnvironment;
        String bundleFragmentHost;
        String bundleRequireCapability;
        String bundleProvideCapability;
        String bundleRequireBundle;
        String bundleImportPackage;
        String bundleDocUrl;
        String bundleLicense;
        String bundleName;
        String bundleDescription;
        String bundleExportService;
        String bundleExportPackage;
        String bundleVersion;
        boolean updated = false;
        String bundleSymbolicName = document.get(FLD_BUNDLE_SYMBOLIC_NAME.getKey());
        if (bundleSymbolicName != null) {
            artifactInfo.setBundleSymbolicName(bundleSymbolicName);
            updated = true;
        }
        if ((bundleVersion = document.get(FLD_BUNDLE_VERSION.getKey())) != null) {
            artifactInfo.setBundleVersion(bundleVersion);
            updated = true;
        }
        if ((bundleExportPackage = document.get(FLD_BUNDLE_EXPORT_PACKAGE.getKey())) != null) {
            artifactInfo.setBundleExportPackage(bundleExportPackage);
            updated = true;
        }
        if ((bundleExportService = document.get(FLD_BUNDLE_EXPORT_SERVIVE.getKey())) != null) {
            artifactInfo.setBundleExportService(bundleExportService);
            updated = true;
        }
        if ((bundleDescription = document.get(FLD_BUNDLE_DESCRIPTION.getKey())) != null) {
            artifactInfo.setBundleDescription(bundleDescription);
            updated = true;
        }
        if ((bundleName = document.get(FLD_BUNDLE_NAME.getKey())) != null) {
            artifactInfo.setBundleName(bundleName);
            updated = true;
        }
        if ((bundleLicense = document.get(FLD_BUNDLE_LICENSE.getKey())) != null) {
            artifactInfo.setBundleLicense(bundleLicense);
            updated = true;
        }
        if ((bundleDocUrl = document.get(FLD_BUNDLE_DOCURL.getKey())) != null) {
            artifactInfo.setBundleDocUrl(bundleDocUrl);
            updated = true;
        }
        if ((bundleImportPackage = document.get(FLD_BUNDLE_IMPORT_PACKAGE.getKey())) != null) {
            artifactInfo.setBundleImportPackage(bundleImportPackage);
            updated = true;
        }
        if ((bundleRequireBundle = document.get(FLD_BUNDLE_REQUIRE_BUNDLE.getKey())) != null) {
            artifactInfo.setBundleRequireBundle(bundleRequireBundle);
            updated = true;
        }
        if ((bundleProvideCapability = document.get(FLD_BUNDLE_PROVIDE_CAPABILITY.getKey())) != null) {
            artifactInfo.setBundleProvideCapability(bundleProvideCapability);
            updated = true;
        }
        if ((bundleRequireCapability = document.get(FLD_BUNDLE_REQUIRE_CAPABILITY.getKey())) != null) {
            artifactInfo.setBundleRequireCapability(bundleRequireCapability);
            updated = true;
        }
        if ((bundleFragmentHost = document.get(FLD_BUNDLE_FRAGMENT_HOST.getKey())) != null) {
            artifactInfo.setBundleFragmentHost(bundleFragmentHost);
            updated = true;
        }
        if ((bundleRequiredExecutionEnvironment = document.get(FLD_BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT.getKey())) != null) {
            artifactInfo.setBundleRequiredExecutionEnvironment(bundleRequiredExecutionEnvironment);
            updated = true;
        }
        if ((sha256 = document.get(FLD_SHA256.getKey())) != null) {
            artifactInfo.setSha256(sha256);
            updated = true;
        }
        return updated;
    }

    private boolean updateArtifactInfo(ArtifactInfo ai, File f) throws IOException {
        boolean updated = false;
        try (ZipFile zipFile = new ZipFile(f);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                Manifest manifest;
                Attributes mainAttributes;
                ZipEntry zipEntry = entries.nextElement();
                if (!zipEntry.getName().equals("META-INF/MANIFEST.MF") || (mainAttributes = (manifest = new Manifest(zipFile.getInputStream(zipEntry))).getMainAttributes()) == null) continue;
                String attValue = mainAttributes.getValue(BSN);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleSymbolicName(attValue);
                    updated = true;
                } else {
                    ai.setBundleSymbolicName(null);
                }
                attValue = mainAttributes.getValue(BV);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleVersion(attValue);
                    updated = true;
                } else {
                    ai.setBundleVersion(null);
                }
                attValue = mainAttributes.getValue(BEP);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleExportPackage(attValue);
                    updated = true;
                } else {
                    ai.setBundleExportPackage(null);
                }
                attValue = mainAttributes.getValue(BES);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleExportService(attValue);
                    updated = true;
                } else {
                    ai.setBundleExportService(null);
                }
                attValue = mainAttributes.getValue(BD);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleDescription(attValue);
                    updated = true;
                } else {
                    ai.setBundleDescription(null);
                }
                attValue = mainAttributes.getValue(BN);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleName(attValue);
                    updated = true;
                } else {
                    ai.setBundleName(null);
                }
                attValue = mainAttributes.getValue(BL);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleLicense(attValue);
                    updated = true;
                } else {
                    ai.setBundleLicense(null);
                }
                attValue = mainAttributes.getValue(BDU);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleDocUrl(attValue);
                    updated = true;
                } else {
                    ai.setBundleDocUrl(null);
                }
                attValue = mainAttributes.getValue(BIP);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleImportPackage(attValue);
                    updated = true;
                } else {
                    ai.setBundleImportPackage(null);
                }
                attValue = mainAttributes.getValue(BRB);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleRequireBundle(attValue);
                    updated = true;
                } else {
                    ai.setBundleRequireBundle(null);
                }
                attValue = mainAttributes.getValue(PROVIDE_CAPABILITY);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleProvideCapability(attValue);
                    updated = true;
                } else {
                    ai.setBundleProvideCapability(null);
                }
                attValue = mainAttributes.getValue(REQUIRE_CAPABILITY);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleRequireCapability(attValue);
                    updated = true;
                } else {
                    ai.setBundleRequireCapability(null);
                }
                attValue = mainAttributes.getValue(FRAGMENT_HOST);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleFragmentHost(attValue);
                    updated = true;
                } else {
                    ai.setBundleFragmentHost(null);
                }
                attValue = mainAttributes.getValue(BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT);
                if (StringUtils.isNotBlank(attValue)) {
                    ai.setBundleRequiredExecutionEnvironment(attValue);
                    updated = true;
                    continue;
                }
                ai.setBundleRequiredExecutionEnvironment(null);
            }
        }
        if (ai.getBundleSymbolicName() != null) {
            String sha256 = this.computeSha256(f);
            if (sha256 != null) {
                ai.setSha256(sha256);
                updated = true;
            } else {
                ai.setSha256(null);
            }
        }
        return updated;
    }

    private String computeSha256(File f) throws IOException {
        String sha256 = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            try (DigestInputStream in = new DigestInputStream(new FileInputStream(f), digest);){
                byte[] buf = new byte[8192];
                while (in.read(buf) >= 0) {
                }
                byte[] digestBytes = digest.digest();
                StringBuilder builder = new StringBuilder(64);
                for (int n : digestBytes) {
                    builder.append(String.format("%02x", n &= 0xFF));
                    sha256 = builder.toString();
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return sha256;
    }

    public String toString() {
        return ID;
    }
}

