/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.creator;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.lucene.document.Document;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.IndexerField;
import org.apache.maven.index.IndexerFieldVersion;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.creator.AbstractIndexCreator;
import org.apache.maven.index.creator.LegacyDocumentUpdater;
import org.codehaus.plexus.util.StringUtils;

@Singleton
@Named(value="jarContent")
public class JarFileContentsIndexCreator
extends AbstractIndexCreator
implements LegacyDocumentUpdater {
    public static final String ID = "jarContent";
    public static final IndexerField FLD_CLASSNAMES = new IndexerField(MAVEN.CLASSNAMES, IndexerFieldVersion.V3, "classnames", "Artifact Classes (tokenized)", IndexerField.ANALYZED_NOT_STORED);
    public static final IndexerField FLD_CLASSNAMES_KW = new IndexerField(MAVEN.CLASSNAMES, IndexerFieldVersion.V1, "c", "Artifact Classes (tokenized on newlines only)", IndexerField.ANALYZED_STORED);

    public JarFileContentsIndexCreator() {
        super(ID);
    }

    @Override
    public void populateArtifactInfo(ArtifactContext artifactContext) throws IOException {
        ArtifactInfo ai = artifactContext.getArtifactInfo();
        File artifactFile = artifactContext.getArtifact();
        if (artifactFile != null && artifactFile.isFile() && (artifactFile.getName().endsWith(".jar") || artifactFile.getName().endsWith(".war") || artifactFile.getName().endsWith(".zip"))) {
            this.updateArtifactInfo(ai, artifactFile);
        }
    }

    @Override
    public void updateDocument(ArtifactInfo ai, Document doc) {
        if (ai.getClassNames() != null) {
            doc.add(FLD_CLASSNAMES_KW.toField(ai.getClassNames()));
            doc.add(FLD_CLASSNAMES.toField(ai.getClassNames()));
        }
    }

    @Override
    public void updateLegacyDocument(ArtifactInfo ai, Document doc) {
        if (ai.getClassNames() != null) {
            String classNames = ai.getClassNames();
            if (classNames.length() > 0 && classNames.charAt(0) == '/') {
                String[] lines = classNames.split("\\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append(line.substring(1)).append('\n');
                }
                classNames = sb.toString();
            }
            doc.add(FLD_CLASSNAMES_KW.toField(classNames));
        }
    }

    @Override
    public boolean updateArtifactInfo(Document doc, ArtifactInfo artifactInfo) {
        String names = doc.get(FLD_CLASSNAMES_KW.getKey());
        if (names != null) {
            if (names.length() == 0 || names.charAt(0) == '/') {
                artifactInfo.setClassNames(names);
            } else {
                String[] lines = names.split("\\n");
                StringBuilder sb = new StringBuilder();
                for (String line : lines) {
                    sb.append('/').append(line).append('\n');
                }
                artifactInfo.setClassNames(sb.toString());
            }
            return true;
        }
        return false;
    }

    private void updateArtifactInfo(ArtifactInfo ai, File f) throws IOException {
        if (f.getName().endsWith(".jar") || f.getName().endsWith(".zip")) {
            this.updateArtifactInfo(ai, f, null);
        } else if (f.getName().endsWith(".war")) {
            this.updateArtifactInfo(ai, f, "WEB-INF/classes/");
        }
    }

    private void updateArtifactInfo(ArtifactInfo ai, File f, String strippedPrefix) throws IOException {
        try (ZipFile zipFile = new ZipFile(f);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            StringBuilder sb = new StringBuilder();
            while (entries.hasMoreElements()) {
                int i;
                String name = entries.nextElement().getName();
                if (!name.endsWith(".class") || (i = name.indexOf("$")) != -1) continue;
                if (name.charAt(0) != '/') {
                    sb.append('/');
                }
                if (StringUtils.isBlank(strippedPrefix)) {
                    sb.append(name, 0, name.length() - 6).append('\n');
                    continue;
                }
                if (!name.startsWith(strippedPrefix) || name.length() <= strippedPrefix.length() + 6) continue;
                sb.append(name, strippedPrefix.length(), name.length() - 6).append('\n');
            }
            String fieldValue = sb.toString().trim();
            if (fieldValue.length() != 0) {
                ai.setClassNames(fieldValue);
            } else {
                ai.setClassNames(null);
            }
        }
    }

    public String toString() {
        return ID;
    }

    @Override
    public Collection<IndexerField> getIndexerFields() {
        return Arrays.asList(FLD_CLASSNAMES, FLD_CLASSNAMES_KW);
    }
}

