/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.queries.function.valuesource.FloatFieldSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;

public class MultiValuedFloatFieldSource
extends FloatFieldSource {
    protected final SortedNumericSelector.Type selector;

    public MultiValuedFloatFieldSource(String field, SortedNumericSelector.Type selector) {
        super(field);
        this.selector = selector;
        Objects.requireNonNull(field, "Field is required to create a MultiValuedFloatFieldSource");
        Objects.requireNonNull(selector, "SortedNumericSelector is required to create a MultiValuedFloatFieldSource");
    }

    @Override
    public SortField getSortField(boolean reverse) {
        return new SortedNumericSortField(this.field, SortField.Type.FLOAT, reverse, this.selector);
    }

    @Override
    public String description() {
        return "float(" + this.field + ',' + this.selector.name() + ')';
    }

    @Override
    protected NumericDocValues getNumericDocValues(Map context, LeafReaderContext readerContext) throws IOException {
        SortedNumericDocValues sortedDv = DocValues.getSortedNumeric(readerContext.reader(), this.field);
        return SortedNumericSelector.wrap(sortedDv, this.selector, SortField.Type.FLOAT);
    }

    @Override
    public boolean equals(Object o) {
        if (o.getClass() != MultiValuedFloatFieldSource.class) {
            return false;
        }
        MultiValuedFloatFieldSource other = (MultiValuedFloatFieldSource)o;
        if (this.selector != other.selector) {
            return false;
        }
        return this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int h2 = super.hashCode();
        return h2 += this.selector.hashCode();
    }
}

