/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.space;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.space.ClassFinder;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.Streams;

public final class IndexedClassFinder
implements ClassFinder {
    private static final Pattern LINE_PATTERN = Pattern.compile("\\s*([^#\\s]+).*");
    private final String localPath;
    private final String indexName;

    public IndexedClassFinder(String name, boolean global) {
        if (global) {
            this.localPath = null;
            this.indexName = name;
        } else {
            int i = name.lastIndexOf(47) + 1;
            this.localPath = name.substring(0, i);
            this.indexName = name.substring(i);
        }
    }

    public Iterable<String> indexedNames(ClassSpace space) {
        Enumeration<URL> indices = this.localPath == null ? space.getResources(this.indexName) : space.findEntries(this.localPath, this.indexName, false);
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        while (indices.hasMoreElements()) {
            URL url = indices.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(Streams.open(url), "UTF-8"));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        Matcher m3 = LINE_PATTERN.matcher(line);
                        if (m3.matches()) {
                            names.add(m3.group(1));
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logs.warn("Problem reading: {}", url, e);
            }
        }
        return names;
    }

    @Override
    public Enumeration<URL> findClasses(final ClassSpace space) {
        final Iterator<String> itr = this.indexedNames(space).iterator();
        return new Enumeration<URL>(){
            private URL nextURL;

            @Override
            public boolean hasMoreElements() {
                while (this.nextURL == null && itr.hasNext()) {
                    this.nextURL = space.getResource(String.valueOf(((String)itr.next()).replace('.', '/')) + ".class");
                }
                return this.nextURL != null;
            }

            @Override
            public URL nextElement() {
                if (this.hasMoreElements()) {
                    URL tempURL = this.nextURL;
                    this.nextURL = null;
                    return tempURL;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

