/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.packer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.incremental.IncrementalHandler;
import org.apache.maven.index.packer.DigesterUtils;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.apache.maven.index.updater.IndexDataWriter;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultIndexPacker
implements IndexPacker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final IncrementalHandler incrementalHandler;

    protected Logger getLogger() {
        return this.logger;
    }

    @Inject
    public DefaultIndexPacker(IncrementalHandler incrementalHandler) {
        this.incrementalHandler = incrementalHandler;
    }

    @Override
    public void packIndex(IndexPackingRequest request) throws IOException, IllegalArgumentException {
        Properties info;
        if (request.getTargetDir() == null) {
            throw new IllegalArgumentException("The target dir is null");
        }
        if (request.getTargetDir().exists()) {
            if (!request.getTargetDir().isDirectory()) {
                throw new IllegalArgumentException(String.format("Specified target path %s is not a directory", request.getTargetDir().getAbsolutePath()));
            }
            if (!request.getTargetDir().canWrite()) {
                throw new IllegalArgumentException(String.format("Specified target path %s is not writtable", request.getTargetDir().getAbsolutePath()));
            }
        } else if (!request.getTargetDir().mkdirs()) {
            throw new IllegalArgumentException("Can't create " + request.getTargetDir().getAbsolutePath());
        }
        File v1File = new File(request.getTargetDir(), "nexus-maven-repository-index.gz");
        try {
            info = this.readIndexProperties(request);
            if (request.isCreateIncrementalChunks()) {
                List<Integer> chunk = this.incrementalHandler.getIncrementalUpdates(request, info);
                if (chunk == null) {
                    this.getLogger().debug("Problem with Chunks, forcing regeneration of whole index");
                    this.incrementalHandler.initializeProperties(info);
                } else if (chunk.isEmpty()) {
                    this.getLogger().debug("No incremental changes, not writing new incremental chunk");
                } else {
                    File file = new File(request.getTargetDir(), "nexus-maven-repository-index." + info.getProperty("nexus.index.last-incremental") + ".gz");
                    this.writeIndexData(request, chunk, file);
                    if (request.isCreateChecksumFiles()) {
                        FileUtils.fileWrite(new File(file.getParentFile(), file.getName() + ".sha1").getAbsolutePath(), DigesterUtils.getSha1Digest(file));
                        FileUtils.fileWrite(new File(file.getParentFile(), file.getName() + ".md5").getAbsolutePath(), DigesterUtils.getMd5Digest(file));
                    }
                }
            }
        }
        catch (IOException e) {
            this.getLogger().info("Unable to read properties file, will force index regeneration");
            info = new Properties();
            this.incrementalHandler.initializeProperties(info);
        }
        Date timestamp = request.getContext().getTimestamp();
        if (timestamp == null) {
            timestamp = new Date(0L);
        }
        if (request.getFormats().contains((Object)IndexPackingRequest.IndexFormat.FORMAT_V1)) {
            info.setProperty("nexus.index.timestamp", this.format(timestamp));
            this.writeIndexData(request, null, v1File);
            if (request.isCreateChecksumFiles()) {
                FileUtils.fileWrite(new File(v1File.getParentFile(), v1File.getName() + ".sha1").getAbsolutePath(), DigesterUtils.getSha1Digest(v1File));
                FileUtils.fileWrite(new File(v1File.getParentFile(), v1File.getName() + ".md5").getAbsolutePath(), DigesterUtils.getMd5Digest(v1File));
            }
        }
        this.writeIndexProperties(request, info);
    }

    private Properties readIndexProperties(IndexPackingRequest request) throws IOException {
        File file = request.isUseTargetProperties() || request.getContext().getIndexDirectoryFile() == null ? new File(request.getTargetDir(), "nexus-maven-repository-index.properties") : new File(request.getContext().getIndexDirectoryFile(), "nexus-maven-repository-index-packer.properties");
        Properties properties = new Properties();
        try (FileInputStream fos = new FileInputStream(file);){
            properties.load(fos);
        }
        return properties;
    }

    void writeIndexData(IndexPackingRequest request, List<Integer> docIndexes, File targetArchive) throws IOException {
        if (targetArchive.exists()) {
            targetArchive.delete();
        }
        try (FileOutputStream os = new FileOutputStream(targetArchive);){
            IndexDataWriter dw = new IndexDataWriter(os);
            dw.write(request.getContext(), request.getIndexReader(), docIndexes);
            os.flush();
        }
    }

    void writeIndexProperties(IndexPackingRequest request, Properties info) throws IOException {
        File propertyFile = new File(request.getContext().getIndexDirectoryFile(), "nexus-maven-repository-index-packer.properties");
        File targetPropertyFile = new File(request.getTargetDir(), "nexus-maven-repository-index.properties");
        info.setProperty("nexus.index.id", request.getContext().getId());
        try (FileOutputStream os = new FileOutputStream(propertyFile);){
            info.store(os, null);
        }
        os = new FileOutputStream(targetPropertyFile);
        try {
            info.store(os, null);
        }
        finally {
            ((OutputStream)os).close();
        }
        if (request.isCreateChecksumFiles()) {
            FileUtils.fileWrite(new File(targetPropertyFile.getParentFile(), targetPropertyFile.getName() + ".sha1").getAbsolutePath(), DigesterUtils.getSha1Digest(targetPropertyFile));
            FileUtils.fileWrite(new File(targetPropertyFile.getParentFile(), targetPropertyFile.getName() + ".md5").getAbsolutePath(), DigesterUtils.getMd5Digest(targetPropertyFile));
        }
    }

    private String format(Date d) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(d);
    }
}

