/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.artifact;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.artifact.GavCalculator;

@Singleton
@Named(value="maven1")
@Deprecated
public class M1GavCalculator
implements GavCalculator {
    private static final Pattern PAT1 = Pattern.compile("^([^0-9]+)-([0-9].+)\\.([^0-9]+)(\\.md5|\\.sha1){0,1}$");
    private static final Pattern PAT2 = Pattern.compile("^([a-z0-9-_]+)-([0-9-].+)\\.([^0-9]+)(\\.md5|\\.sha1){0,1}$");

    @Override
    public Gav pathToGav(String str) {
        try {
            String s2 = str.startsWith("/") ? str.substring(1) : str;
            int n1 = s2.lastIndexOf(47);
            if (n1 == -1) {
                return null;
            }
            int n2 = s2.lastIndexOf(47, n1 - 1);
            if (n2 == -1) {
                return null;
            }
            String g2 = s2.substring(0, n2).replace('/', '.');
            String middle = s2.substring(n2 + 1, n1);
            String n = s2.substring(n1 + 1);
            String classifier = null;
            if ("java-sources".equals(middle)) {
                classifier = "sources";
            } else if ("javadocs".equals(middle)) {
                classifier = "javadoc";
            } else if ("ejbs".equals(middle) && (n.endsWith("client.jar") || n.endsWith("client.jar.sha1") || n.endsWith("client.jar.md5"))) {
                classifier = "client";
            }
            boolean checksum = false;
            Gav.HashType checksumType = null;
            if (s2.endsWith(".md5")) {
                checksum = true;
                checksumType = Gav.HashType.md5;
                s2 = s2.substring(0, s2.length() - 4);
            } else if (s2.endsWith(".sha1")) {
                checksum = true;
                checksumType = Gav.HashType.sha1;
                s2 = s2.substring(0, s2.length() - 5);
            }
            if (s2.endsWith("maven-metadata.xml")) {
                return null;
            }
            String ext = s2.substring(s2.lastIndexOf(46) + 1);
            Matcher m3 = PAT1.matcher(n);
            if (m3.matches()) {
                String a = m3.group(1);
                String version = m3.group(2);
                if (classifier != null) {
                    version = version.substring(0, version.length() - (classifier.length() + 1));
                }
                return new Gav(g2, a, version, classifier, ext, null, null, n, checksum, checksumType, false, null);
            }
            m3 = PAT2.matcher(n);
            if (m3.matches()) {
                String a = m3.group(1);
                String version = m3.group(2);
                if (classifier != null) {
                    version = version.substring(0, version.length() - (classifier.length() + 1));
                }
                return new Gav(g2, a, version, classifier, ext, null, null, n, checksum, checksumType, false, null);
            }
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public String gavToPath(Gav gav) {
        StringBuilder path = new StringBuilder("/");
        path.append(gav.getGroupId());
        path.append("/");
        if (gav.getClassifier() == null) {
            path.append(gav.getExtension());
        } else if (gav.getClassifier().startsWith("source")) {
            path.append("java-source");
        } else if (gav.getClassifier().startsWith("client")) {
            path.append("ejb");
        } else {
            path.append(gav.getClassifier());
        }
        path.append("s");
        path.append("/");
        path.append(gav.getArtifactId());
        path.append("-");
        path.append(gav.getVersion());
        if (gav.getClassifier() != null) {
            path.append("-");
            path.append(gav.getClassifier());
        }
        path.append(".");
        path.append(gav.getExtension());
        if (gav.isHash()) {
            path.append(".");
            path.append(gav.getHashType().toString());
        }
        return path.toString();
    }
}

