/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongHashSet;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class DocValuesNumbersQuery
extends Query
implements Accountable {
    private static final long BASE_RAM_BYTES = RamUsageEstimator.shallowSizeOfInstance(DocValuesNumbersQuery.class);
    private final String field;
    private final LongHashSet numbers;

    public DocValuesNumbersQuery(String field, long[] numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers);
    }

    public DocValuesNumbersQuery(String field, Collection<Long> numbers) {
        this.field = Objects.requireNonNull(field);
        this.numbers = new LongHashSet(numbers.stream().mapToLong(Long::longValue).toArray());
    }

    public DocValuesNumbersQuery(String field, Long ... numbers) {
        this(field, new HashSet<Long>(Arrays.asList(numbers)));
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((DocValuesNumbersQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(DocValuesNumbersQuery other) {
        return this.field.equals(other.field) && this.numbers.equals(other.numbers);
    }

    @Override
    public int hashCode() {
        return 31 * this.classHash() + Objects.hash(this.field, this.numbers);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf(this);
        }
    }

    public String getField() {
        return this.field;
    }

    public Set<Long> getNumbers() {
        return this.numbers;
    }

    @Override
    public String toString(String defaultField) {
        return this.field + ": " + this.numbers.toString();
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES + RamUsageEstimator.sizeOfObject(this.field) + RamUsageEstimator.sizeOfObject(this.numbers);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = DocValues.getSortedNumeric(context.reader(), DocValuesNumbersQuery.this.field);
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, new TwoPhaseIterator(values){

                    @Override
                    public boolean matches() throws IOException {
                        int count = values.docValueCount();
                        for (int i = 0; i < count; ++i) {
                            if (!DocValuesNumbersQuery.this.numbers.contains(values.nextValue())) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 5.0f;
                    }
                });
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }
}

