/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.index.ArtifactAvailability;
import org.apache.maven.index.ArtifactInfoRecord;
import org.apache.maven.index.Field;
import org.apache.maven.index.MAVEN;
import org.apache.maven.index.MatchHighlight;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;
import org.apache.maven.index.creator.MavenPluginArtifactInfoIndexCreator;
import org.apache.maven.index.creator.MinimalArtifactInfoIndexCreator;
import org.apache.maven.index.creator.OsgiArtifactIndexCreator;
import org.eclipse.aether.util.version.GenericVersionScheme;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionScheme;

public class ArtifactInfo
extends ArtifactInfoRecord {
    private static final long serialVersionUID = 6028843453477511105L;
    public static final String ROOT_GROUPS = "rootGroups";
    public static final String ROOT_GROUPS_VALUE = "rootGroups";
    public static final String ROOT_GROUPS_LIST = "rootGroupsList";
    public static final String ALL_GROUPS = "allGroups";
    public static final String ALL_GROUPS_VALUE = "allGroups";
    public static final String ALL_GROUPS_LIST = "allGroupsList";
    public static final String UINFO = FLD_UINFO.getKey();
    public static final String DELETED = FLD_DELETED.getKey();
    public static final String GROUP_ID = MinimalArtifactInfoIndexCreator.FLD_GROUP_ID_KW.getKey();
    public static final String ARTIFACT_ID = MinimalArtifactInfoIndexCreator.FLD_ARTIFACT_ID_KW.getKey();
    public static final String VERSION = MinimalArtifactInfoIndexCreator.FLD_VERSION_KW.getKey();
    public static final String PACKAGING = MinimalArtifactInfoIndexCreator.FLD_PACKAGING.getKey();
    public static final String CLASSIFIER = MinimalArtifactInfoIndexCreator.FLD_CLASSIFIER.getKey();
    public static final String INFO = MinimalArtifactInfoIndexCreator.FLD_INFO.getKey();
    public static final String NAME = MinimalArtifactInfoIndexCreator.FLD_NAME.getKey();
    public static final String DESCRIPTION = MinimalArtifactInfoIndexCreator.FLD_DESCRIPTION.getKey();
    public static final String LAST_MODIFIED = MinimalArtifactInfoIndexCreator.FLD_LAST_MODIFIED.getKey();
    public static final String SHA1 = MinimalArtifactInfoIndexCreator.FLD_SHA1.getKey();
    public static final String NAMES = JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey();
    public static final String PLUGIN_PREFIX = MavenPluginArtifactInfoIndexCreator.FLD_PLUGIN_PREFIX.getKey();
    public static final String PLUGIN_GOALS = MavenPluginArtifactInfoIndexCreator.FLD_PLUGIN_GOALS.getKey();
    public static final String BUNDLE_SYMBOLIC_NAME = OsgiArtifactIndexCreator.FLD_BUNDLE_SYMBOLIC_NAME.getKey();
    public static final String BUNDLE_VERSION = OsgiArtifactIndexCreator.FLD_BUNDLE_VERSION.getKey();
    public static final String BUNDLE_EXPORT_PACKAGE = OsgiArtifactIndexCreator.FLD_BUNDLE_EXPORT_PACKAGE.getKey();
    public static final String BUNDLE_PROVIDE_CAPABILITY = OsgiArtifactIndexCreator.FLD_BUNDLE_PROVIDE_CAPABILITY.getKey();
    public static final String BUNDLE_REQUIRE_CAPABILITY = OsgiArtifactIndexCreator.FLD_BUNDLE_REQUIRE_CAPABILITY.getKey();
    public static final Comparator<ArtifactInfo> VERSION_COMPARATOR = new VersionComparator();
    public static final Comparator<ArtifactInfo> REPOSITORY_VERSION_COMPARATOR = new RepositoryVersionComparator();
    public static final Comparator<ArtifactInfo> CONTEXT_VERSION_COMPARATOR = new ContextVersionComparator();
    private String fileName;
    private String fileExtension;
    private String groupId;
    private String artifactId;
    private String version;
    private transient Version artifactVersion;
    private transient float luceneScore;
    private String classifier;
    private String packaging;
    private String name;
    private String description;
    private long lastModified = -1L;
    private long size = -1L;
    private String md5;
    private String sha1;
    private ArtifactAvailability sourcesExists = ArtifactAvailability.NOT_PRESENT;
    private ArtifactAvailability javadocExists = ArtifactAvailability.NOT_PRESENT;
    private ArtifactAvailability signatureExists = ArtifactAvailability.NOT_PRESENT;
    private String classNames;
    private String repository;
    private String path;
    private String remoteUrl;
    private String context;
    private String prefix;
    private List<String> goals;
    private String bundleVersion;
    private String bundleSymbolicName;
    private String bundleExportPackage;
    private String bundleExportService;
    private String bundleDescription;
    private String bundleName;
    private String bundleLicense;
    private String bundleDocUrl;
    private String bundleImportPackage;
    private String bundleRequireBundle;
    private String bundleProvideCapability;
    private String bundleRequireCapability;
    private String sha256;
    private String bundleFragmentHost;
    private String bundleRequiredExecutionEnvironment;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final List<MatchHighlight> matchHighlights = new ArrayList<MatchHighlight>();
    private final transient VersionScheme versionScheme = new GenericVersionScheme();
    private static final List<Field> DEFAULT_FIELDS = new ArrayList<Field>();
    private List<Field> fields;

    public ArtifactInfo() {
    }

    public ArtifactInfo(String repository, String groupId, String artifactId, String version, String classifier, String extension) {
        this();
        this.repository = repository;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
        this.fileExtension = extension;
    }

    public Version getArtifactVersion() {
        if (this.artifactVersion == null) {
            try {
                this.artifactVersion = this.versionScheme.parseVersion(this.version);
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
        return this.artifactVersion;
    }

    public float getLuceneScore() {
        return this.luceneScore;
    }

    public void setLuceneScore(float score) {
        this.luceneScore = score;
    }

    public String getUinfo() {
        return this.groupId + "|" + this.artifactId + "|" + this.version + "|" + ArtifactInfo.nvl(this.classifier) + "|" + this.fileExtension;
    }

    public String getRootGroup() {
        int n = this.groupId.indexOf(46);
        if (n > -1) {
            return this.groupId.substring(0, n);
        }
        return this.groupId;
    }

    public Gav calculateGav() {
        return new Gav(this.groupId, this.artifactId, this.version, this.classifier, this.fileExtension, null, null, this.fileName, false, null, false, null);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public List<MatchHighlight> getMatchHighlights() {
        return this.matchHighlights;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getUinfo());
        String packaging = this.getPackaging();
        if (packaging != null && !this.getPackaging().isEmpty()) {
            result.append("[").append(this.getPackaging()).append("]");
        }
        return result.toString();
    }

    public Collection<Field> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<Field>(DEFAULT_FIELDS.size());
            this.fields.addAll(DEFAULT_FIELDS);
        }
        return this.fields;
    }

    public String getFieldValue(Field field) {
        if (MAVEN.GROUP_ID.equals(field)) {
            return this.groupId;
        }
        if (MAVEN.ARTIFACT_ID.equals(field)) {
            return this.artifactId;
        }
        if (MAVEN.VERSION.equals(field)) {
            return this.version;
        }
        if (MAVEN.PACKAGING.equals(field)) {
            return this.packaging;
        }
        if (MAVEN.CLASSIFIER.equals(field)) {
            return this.classifier;
        }
        if (MAVEN.SHA1.equals(field)) {
            return this.sha1;
        }
        if (MAVEN.NAME.equals(field)) {
            return this.name;
        }
        if (MAVEN.DESCRIPTION.equals(field)) {
            return this.description;
        }
        if (MAVEN.CLASSNAMES.equals(field)) {
            return this.classNames;
        }
        if (MAVEN.REPOSITORY_ID.equals(field)) {
            return this.repository;
        }
        return null;
    }

    public ArtifactInfo setFieldValue(Field field, String value) {
        if (MAVEN.GROUP_ID.equals(field)) {
            this.groupId = value;
        } else if (MAVEN.ARTIFACT_ID.equals(field)) {
            this.artifactId = value;
        } else if (MAVEN.VERSION.equals(field)) {
            this.version = value;
        } else if (MAVEN.PACKAGING.equals(field)) {
            this.packaging = value;
        } else if (MAVEN.CLASSIFIER.equals(field)) {
            this.classifier = value;
        } else if (MAVEN.SHA1.equals(field)) {
            this.sha1 = value;
        } else if (MAVEN.NAME.equals(field)) {
            this.name = value;
        } else if (MAVEN.DESCRIPTION.equals(field)) {
            this.description = value;
        } else if (MAVEN.CLASSNAMES.equals(field)) {
            this.classNames = value;
        } else if (MAVEN.REPOSITORY_ID.equals(field)) {
            this.repository = value;
        }
        return this;
    }

    public static String nvl(String v) {
        return v == null ? "NA" : v;
    }

    public static String renvl(String v) {
        return "NA".equals(v) ? null : v;
    }

    public static String lst2str(Collection<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s2 : list) {
            sb.append(s2).append("|");
        }
        return sb.length() == 0 ? sb.toString() : sb.substring(0, sb.length() - 1);
    }

    public static List<String> str2lst(String str) {
        return Arrays.asList(FS_PATTERN.split(str));
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setArtifactVersion(Version artifactVersion) {
        this.artifactVersion = artifactVersion;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public void setClassifier(String classifier) {
        this.classifier = classifier;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public ArtifactAvailability getSourcesExists() {
        return this.sourcesExists;
    }

    public void setSourcesExists(ArtifactAvailability sourcesExists) {
        this.sourcesExists = sourcesExists;
    }

    public ArtifactAvailability getJavadocExists() {
        return this.javadocExists;
    }

    public void setJavadocExists(ArtifactAvailability javadocExists) {
        this.javadocExists = javadocExists;
    }

    public ArtifactAvailability getSignatureExists() {
        return this.signatureExists;
    }

    public void setSignatureExists(ArtifactAvailability signatureExists) {
        this.signatureExists = signatureExists;
    }

    public String getClassNames() {
        return this.classNames;
    }

    public void setClassNames(String classNames) {
        this.classNames = classNames;
    }

    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<String> getGoals() {
        return this.goals;
    }

    public void setGoals(List<String> goals) {
        this.goals = goals;
    }

    public String getBundleVersion() {
        return this.bundleVersion;
    }

    public void setBundleVersion(String bundleVersion) {
        this.bundleVersion = bundleVersion;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public void setBundleSymbolicName(String bundleSymbolicName) {
        this.bundleSymbolicName = bundleSymbolicName;
    }

    public String getBundleExportPackage() {
        return this.bundleExportPackage;
    }

    public void setBundleExportPackage(String bundleExportPackage) {
        this.bundleExportPackage = bundleExportPackage;
    }

    public String getBundleExportService() {
        return this.bundleExportService;
    }

    public void setBundleExportService(String bundleExportService) {
        this.bundleExportService = bundleExportService;
    }

    public String getBundleDescription() {
        return this.bundleDescription;
    }

    public void setBundleDescription(String bundleDescription) {
        this.bundleDescription = bundleDescription;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String bundleName) {
        this.bundleName = bundleName;
    }

    public String getBundleLicense() {
        return this.bundleLicense;
    }

    public void setBundleLicense(String bundleLicense) {
        this.bundleLicense = bundleLicense;
    }

    public String getBundleDocUrl() {
        return this.bundleDocUrl;
    }

    public void setBundleDocUrl(String bundleDocUrl) {
        this.bundleDocUrl = bundleDocUrl;
    }

    public String getBundleImportPackage() {
        return this.bundleImportPackage;
    }

    public void setBundleImportPackage(String bundleImportPackage) {
        this.bundleImportPackage = bundleImportPackage;
    }

    public String getBundleRequireBundle() {
        return this.bundleRequireBundle;
    }

    public void setBundleRequireBundle(String bundleRequireBundle) {
        this.bundleRequireBundle = bundleRequireBundle;
    }

    public VersionScheme getVersionScheme() {
        return this.versionScheme;
    }

    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public String getBundleProvideCapability() {
        return this.bundleProvideCapability;
    }

    public void setBundleProvideCapability(String bundleProvideCapability) {
        this.bundleProvideCapability = bundleProvideCapability;
    }

    public String getBundleRequireCapability() {
        return this.bundleRequireCapability;
    }

    public void setBundleRequireCapability(String bundleRequireCapability) {
        this.bundleRequireCapability = bundleRequireCapability;
    }

    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public String getBundleFragmentHost() {
        return this.bundleFragmentHost;
    }

    public void setBundleFragmentHost(String bundleFragmentHost) {
        this.bundleFragmentHost = bundleFragmentHost;
    }

    public String getBundleRequiredExecutionEnvironment() {
        return this.bundleRequiredExecutionEnvironment;
    }

    public void setBundleRequiredExecutionEnvironment(String bundleRequiredExecutionEnvironment) {
        this.bundleRequiredExecutionEnvironment = bundleRequiredExecutionEnvironment;
    }

    static {
        DEFAULT_FIELDS.add(MAVEN.GROUP_ID);
        DEFAULT_FIELDS.add(MAVEN.ARTIFACT_ID);
        DEFAULT_FIELDS.add(MAVEN.VERSION);
        DEFAULT_FIELDS.add(MAVEN.PACKAGING);
        DEFAULT_FIELDS.add(MAVEN.CLASSIFIER);
        DEFAULT_FIELDS.add(MAVEN.SHA1);
        DEFAULT_FIELDS.add(MAVEN.NAME);
        DEFAULT_FIELDS.add(MAVEN.DESCRIPTION);
        DEFAULT_FIELDS.add(MAVEN.CLASSNAMES);
        DEFAULT_FIELDS.add(MAVEN.REPOSITORY_ID);
    }

    static class VersionComparator
    implements Comparator<ArtifactInfo> {
        VersionComparator() {
        }

        @Override
        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = f1.groupId.compareTo(f2.groupId);
            if (n != 0) {
                return n;
            }
            n = f1.artifactId.compareTo(f2.artifactId);
            if (n != 0) {
                return n;
            }
            n = -f1.getArtifactVersion().compareTo(f2.getArtifactVersion());
            if (n != 0) {
                return n;
            }
            String c1 = f1.classifier;
            String c2 = f2.classifier;
            if (c1 == null) {
                if (c2 != null) {
                    return -1;
                }
            } else {
                if (c2 == null) {
                    return 1;
                }
                n = c1.compareTo(c2);
                if (n != 0) {
                    return n;
                }
            }
            String p1 = f1.packaging;
            String p2 = f2.packaging;
            if (p1 == null) {
                return p2 == null ? 0 : -1;
            }
            return p2 == null ? 1 : p1.compareTo(p2);
        }
    }

    static class RepositoryVersionComparator
    extends VersionComparator {
        RepositoryVersionComparator() {
        }

        @Override
        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = super.compare(f1, f2);
            if (n != 0) {
                return n;
            }
            String r1 = f1.repository;
            String r2 = f2.repository;
            if (r1 == null) {
                return r2 == null ? 0 : -1;
            }
            return r2 == null ? 1 : r1.compareTo(r2);
        }
    }

    static class ContextVersionComparator
    extends VersionComparator {
        ContextVersionComparator() {
        }

        @Override
        public int compare(ArtifactInfo f1, ArtifactInfo f2) {
            int n = super.compare(f1, f2);
            if (n != 0) {
                return n;
            }
            String r1 = f1.context;
            String r2 = f2.context;
            if (r1 == null) {
                return r2 == null ? 0 : -1;
            }
            return r2 == null ? 1 : r1.compareTo(r2);
        }
    }
}

