/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.aether.util.listener;

import java.nio.ByteBuffer;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferResource;

public class DefaultTransferEvent
implements TransferEvent {
    private TransferEvent.EventType type = TransferEvent.EventType.INITIATED;
    private TransferEvent.RequestType requestType = TransferEvent.RequestType.GET;
    private TransferResource resource;
    private ByteBuffer dataBuffer;
    private long transferredBytes;
    private Exception exception;

    public TransferEvent.EventType getType() {
        return this.type;
    }

    public DefaultTransferEvent setType(TransferEvent.EventType type) {
        if (type == null) {
            throw new IllegalArgumentException("event type not specified");
        }
        this.type = type;
        return this;
    }

    public TransferEvent.RequestType getRequestType() {
        return this.requestType;
    }

    public DefaultTransferEvent setRequestType(TransferEvent.RequestType requestType) {
        if (requestType == null) {
            throw new IllegalArgumentException("request type not specified");
        }
        this.requestType = requestType;
        return this;
    }

    public TransferResource getResource() {
        return this.resource;
    }

    public DefaultTransferEvent setResource(TransferResource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("transfer resource not specified");
        }
        this.resource = resource;
        return this;
    }

    public long getTransferredBytes() {
        return this.transferredBytes;
    }

    public DefaultTransferEvent setTransferredBytes(long transferredBytes) {
        if (transferredBytes < 0L) {
            throw new IllegalArgumentException("number of transferred bytes cannot be negative");
        }
        this.transferredBytes = transferredBytes;
        return this;
    }

    public int getDataLength() {
        return this.dataBuffer != null ? this.dataBuffer.remaining() : 0;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer != null ? this.dataBuffer.asReadOnlyBuffer() : null;
    }

    public DefaultTransferEvent setDataBuffer(byte[] buffer, int offset, int length) {
        return this.setDataBuffer(ByteBuffer.wrap(buffer, offset, length));
    }

    public DefaultTransferEvent setDataBuffer(ByteBuffer dataBuffer) {
        this.dataBuffer = dataBuffer;
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public DefaultTransferEvent setException(Exception exception) {
        this.exception = exception;
        return this;
    }

    public String toString() {
        return (Object)((Object)this.getRequestType()) + " " + (Object)((Object)this.getType()) + " " + this.getResource();
    }
}

