/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.io;

import de.schlichtherle.truezip.io.InputException;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

@DefaultAnnotation(value={NonNull.class})
public final class Streams {
    private static final ExecutorService executor = Executors.newCachedThreadPool(new InputStreamReaderThreadFactory());

    private Streams() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        try {
            Streams.cat(in, out);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new InputException(ex);
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cat(final InputStream in, OutputStream out) throws IOException {
        if (in == null || out == null) {
            throw new NullPointerException();
        }
        final Buffer[] buffers = Streams.allocateBuffers();
        try {
            class Reader
            implements Runnable {
                int off;
                int len;
                volatile InputException exception;

                Reader() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int read;
                    InputStream _in = in;
                    Buffer[] _buffers = buffers;
                    int _buffersLen = buffers.length;
                    do {
                        Buffer buffer;
                        Reader reader = this;
                        synchronized (reader) {
                            while (this.len >= _buffersLen) {
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException interrupted) {
                                    return;
                                }
                            }
                            buffer = _buffers[(this.off + this.len) % _buffersLen];
                        }
                        byte[] buf = buffer.buf;
                        try {
                            read = _in.read(buf, 0, buf.length);
                        }
                        catch (IOException ex) {
                            this.exception = new InputException(ex);
                            read = -1;
                        }
                        buffer.read = read;
                        Reader reader2 = this;
                        synchronized (reader2) {
                            ++this.len;
                            this.notify();
                        }
                    } while (read != -1);
                }
            }
            Reader reader = new Reader();
            Future<?> task = executor.submit(reader);
            int buffersLen = buffers.length;
            while (true) {
                Buffer buffer;
                int off;
                Reader reader2 = reader;
                synchronized (reader2) {
                    while (reader.len <= 0) {
                        try {
                            reader.wait();
                        }
                        catch (InterruptedException ignored) {}
                    }
                    off = reader.off;
                    buffer = buffers[off];
                }
                int write = buffer.read;
                if (write == -1) break;
                byte[] buf = buffer.buf;
                try {
                    out.write(buf, 0, write);
                }
                catch (IOException ex) {
                    task.cancel(true);
                    while (true) {
                        try {
                            task.get();
                        }
                        catch (CancellationException ex2) {
                        }
                        catch (ExecutionException ex2) {
                            throw new AssertionError((Object)ex2);
                        }
                        catch (InterruptedException ex2) {
                            Logger.getLogger(Streams.class.getName()).log(Level.INFO, ex2.getLocalizedMessage(), ex2);
                            continue;
                        }
                        break;
                    }
                    throw ex;
                }
                Reader reader3 = reader;
                synchronized (reader3) {
                    reader.off = (off + 1) % buffersLen;
                    --reader.len;
                    reader.notify();
                }
            }
            if (reader.exception != null) {
                throw reader.exception;
            }
        }
        finally {
            Streams.releaseBuffers(buffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Buffer[] allocateBuffers() {
        List<Reference<Buffer[]>> list = Buffer.list;
        synchronized (list) {
            Iterator<Reference<Buffer[]>> i = Buffer.list.iterator();
            while (i.hasNext()) {
                Buffer[] buffers = i.next().get();
                i.remove();
                if (buffers == null) continue;
                return buffers;
            }
        }
        Buffer[] buffers = new Buffer[4];
        int i = buffers.length;
        while (--i >= 0) {
            buffers[i] = new Buffer();
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseBuffers(Buffer[] buffers) {
        List<Reference<Buffer[]>> list = Buffer.list;
        synchronized (list) {
            Buffer.list.add(new SoftReference<Buffer[]>(buffers));
        }
    }

    private static class Buffer {
        static final List<Reference<Buffer[]>> list = new LinkedList<Reference<Buffer[]>>();
        byte[] buf = new byte[65536];
        int read;

        private Buffer() {
        }
    }

    private static class InputStreamReaderThreadFactory
    implements ThreadFactory {
        private InputStreamReaderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "TrueZIP InputStream Reader");
            t.setDaemon(true);
            return t;
        }
    }
}

