/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.sl;

import de.schlichtherle.truezip.fs.FsDefaultManager;
import de.schlichtherle.truezip.fs.FsFailSafeManager;
import de.schlichtherle.truezip.fs.FsManager;
import de.schlichtherle.truezip.fs.FsManagerService;
import de.schlichtherle.truezip.fs.spi.FsManagerProvider;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.Immutable;

@Immutable
public final class FsManagerLocator
implements FsManagerService {
    public static final FsManagerLocator SINGLETON = new FsManagerLocator();
    private final FsManager manager;

    private FsManagerLocator() {
        FsManager manager;
        Iterator<FsManagerProvider> i;
        Logger logger = Logger.getLogger(FsManagerLocator.class.getName(), FsManagerLocator.class.getName());
        ServiceLocator locator = new ServiceLocator(FsManagerLocator.class.getClassLoader());
        FsManagerProvider provider = locator.getService(FsManagerProvider.class, null);
        if (null == provider && (i = locator.getServices(FsManagerProvider.class)).hasNext()) {
            provider = i.next();
        }
        if (null == provider) {
            manager = new FsFailSafeManager(new FsDefaultManager());
        } else {
            logger.log(Level.CONFIG, "located", provider);
            manager = provider.getManager();
        }
        this.manager = manager;
        logger.log(Level.CONFIG, null != provider ? "provided" : "default", manager);
    }

    @Override
    public FsManager getManager() {
        return this.manager;
    }
}

