/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.entry.EntryContainer;
import de.schlichtherle.truezip.entry.EntryFactory;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemException;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystemOperation;
import de.schlichtherle.truezip.fs.archive.FsReadOnlyArchiveFileSystemException;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
final class FsReadOnlyArchiveFileSystem<E extends FsArchiveEntry>
extends FsArchiveFileSystem<E> {
    FsReadOnlyArchiveFileSystem(@NonNull EntryContainer<E> archive, @NonNull EntryFactory<E> factory, @CheckForNull Entry rootTemplate) {
        super(factory, archive, rootTemplate);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean isTouched() {
        assert (!super.isTouched());
        return false;
    }

    @Override
    @NonNull
    public FsArchiveFileSystemOperation<E> mknod(@NonNull FsEntryName name, @NonNull Entry.Type type, @NonNull BitField<FsOutputOption> options, @CheckForNull Entry template) throws FsArchiveFileSystemException {
        throw new FsReadOnlyArchiveFileSystemException();
    }

    @Override
    public void unlink(FsEntryName path) throws FsArchiveFileSystemException {
        throw new FsReadOnlyArchiveFileSystemException();
    }

    @Override
    public boolean setTime(FsEntryName path, BitField<Entry.Access> types, long value) throws FsArchiveFileSystemException {
        throw new FsReadOnlyArchiveFileSystemException();
    }
}

