/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive;

import de.schlichtherle.truezip.fs.FsConcurrentModel;
import de.schlichtherle.truezip.fs.FsFalsePositiveException;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.archive.FsArchiveController;
import de.schlichtherle.truezip.fs.archive.FsArchiveEntry;
import de.schlichtherle.truezip.fs.archive.FsArchiveFileSystem;
import de.schlichtherle.truezip.fs.archive.FsCacheableFalsePositiveException;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.DefaultAnnotation;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
@DefaultAnnotation(value={NonNull.class})
abstract class FsFileSystemArchiveController<E extends FsArchiveEntry>
extends FsArchiveController<E> {
    private MountState<E> mountState = new ResetFileSystem();

    FsFileSystemArchiveController(FsConcurrentModel model) {
        super(model);
    }

    @Override
    final FsArchiveFileSystem<E> autoMount(boolean autoCreate, BitField<FsOutputOption> options) throws IOException {
        return this.mountState.autoMount(autoCreate, options);
    }

    @Nullable
    final FsArchiveFileSystem<E> getFileSystem() {
        return this.mountState.getFileSystem();
    }

    final void setFileSystem(@CheckForNull FsArchiveFileSystem<E> fileSystem) {
        this.mountState.setFileSystem(fileSystem);
    }

    abstract void mount(boolean var1, BitField<FsOutputOption> var2) throws IOException;

    private class FalsePositiveFileSystem
    extends MountState<E> {
        private FsFalsePositiveException exception;

        private FalsePositiveFileSystem(FsFalsePositiveException exception) {
            if (exception == null) {
                throw new NullPointerException();
            }
            this.exception = exception;
        }

        @Override
        FsArchiveFileSystem<E> autoMount(boolean autoCreate, BitField<FsOutputOption> options) throws FsFalsePositiveException {
            throw this.exception;
        }

        @Override
        void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            FsFileSystemArchiveController.this.mountState = null != fileSystem ? new MountedFileSystem(fileSystem) : new ResetFileSystem();
        }
    }

    private class MountedFileSystem
    extends MountState<E> {
        private final FsArchiveFileSystem<E> fileSystem;

        MountedFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem == null) {
                throw new NullPointerException();
            }
            this.fileSystem = fileSystem;
        }

        @Override
        FsArchiveFileSystem<E> autoMount(boolean autoCreate, BitField<FsOutputOption> options) {
            return this.fileSystem;
        }

        @Override
        FsArchiveFileSystem<E> getFileSystem() {
            return this.fileSystem;
        }

        @Override
        void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem != null) {
                throw new IllegalArgumentException("File system already mounted!");
            }
            FsFileSystemArchiveController.this.mountState = new ResetFileSystem();
        }
    }

    private class ResetFileSystem
    extends MountState<E> {
        private ResetFileSystem() {
        }

        @Override
        FsArchiveFileSystem<E> autoMount(boolean autoCreate, BitField<FsOutputOption> options) throws IOException {
            FsFileSystemArchiveController.this.getModel().assertWriteLockedByCurrentThread();
            try {
                FsFileSystemArchiveController.this.mount(autoCreate, options);
            }
            catch (FsCacheableFalsePositiveException ex) {
                FsFileSystemArchiveController.this.mountState = new FalsePositiveFileSystem(ex);
                throw ex;
            }
            assert (this != FsFileSystemArchiveController.this.mountState);
            return FsFileSystemArchiveController.this.mountState.autoMount(autoCreate, options);
        }

        @Override
        void setFileSystem(FsArchiveFileSystem<E> fileSystem) {
            if (fileSystem != null) {
                FsFileSystemArchiveController.this.mountState = new MountedFileSystem(fileSystem);
            }
        }
    }

    private static abstract class MountState<E extends FsArchiveEntry> {
        private MountState() {
        }

        abstract FsArchiveFileSystem<E> autoMount(boolean var1, BitField<FsOutputOption> var2) throws IOException;

        @Nullable
        FsArchiveFileSystem<E> getFileSystem() {
            return null;
        }

        abstract void setFileSystem(@CheckForNull FsArchiveFileSystem<E> var1);
    }
}

