/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsDecoratingController;
import de.schlichtherle.truezip.fs.FsEntryName;
import de.schlichtherle.truezip.fs.FsInputOption;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsOutputOption;
import de.schlichtherle.truezip.fs.FsStatisticsManager;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import de.schlichtherle.truezip.socket.DecoratingInputSocket;
import de.schlichtherle.truezip.socket.DecoratingOutputSocket;
import de.schlichtherle.truezip.socket.InputSocket;
import de.schlichtherle.truezip.socket.OutputSocket;
import de.schlichtherle.truezip.util.BitField;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
final class FsStatisticsController
extends FsDecoratingController<FsModel, FsController<?>> {
    private final FsStatisticsManager manager;

    FsStatisticsController(@NonNull FsController<?> controller, @NonNull FsStatisticsManager manager) {
        super(controller);
        assert (null != manager);
        this.manager = manager;
    }

    @Override
    public InputSocket<?> getInputSocket(FsEntryName name, BitField<FsInputOption> options) {
        return new Input(name, options);
    }

    @Override
    public OutputSocket<?> getOutputSocket(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
        return new Output(name, options, template);
    }

    private class Output
    extends DecoratingOutputSocket<Entry> {
        Output(FsEntryName name, BitField<FsOutputOption> options, Entry template) {
            super(FsStatisticsController.this.delegate.getOutputSocket(name, options, template));
        }

        @Override
        public OutputStream newOutputStream() throws IOException {
            return FsStatisticsController.this.manager.getStatistics().countBytes(this.getBoundSocket().newOutputStream());
        }
    }

    private class Input
    extends DecoratingInputSocket<Entry> {
        Input(FsEntryName name, BitField<FsInputOption> options) {
            super(FsStatisticsController.this.delegate.getInputSocket(name, options));
        }

        @Override
        public ReadOnlyFile newReadOnlyFile() throws IOException {
            return FsStatisticsController.this.manager.getStatistics().countBytes(this.getBoundSocket().newReadOnlyFile());
        }

        @Override
        public InputStream newInputStream() throws IOException {
            return FsStatisticsController.this.manager.getStatistics().countBytes(this.getBoundSocket().newInputStream());
        }
    }
}

