/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsController;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsStatisticsManager;
import de.schlichtherle.truezip.io.DecoratingInputStream;
import de.schlichtherle.truezip.io.DecoratingOutputStream;
import de.schlichtherle.truezip.rof.DecoratingReadOnlyFile;
import de.schlichtherle.truezip.rof.ReadOnlyFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class FsStatistics {
    private final FsStatisticsManager manager;
    private volatile long read;
    private volatile long written;

    FsStatistics(FsStatisticsManager manager) {
        this.manager = manager;
    }

    public int getFileSystemsTotal() {
        return this.manager.getSize();
    }

    public int getFileSystemsTouched() {
        int result = 0;
        for (FsController<?> controller : this.manager) {
            if (!((FsModel)controller.getModel()).isTouched()) continue;
            ++result;
        }
        return result;
    }

    public int getTopLevelFileSystemsTotal() {
        int result = 0;
        for (FsController<?> controller : this.manager) {
            if (null != controller.getParent().getParent()) continue;
            ++result;
        }
        return result;
    }

    public int getTopLevelFileSystemsTouched() {
        int result = 0;
        for (FsController<?> controller : this.manager) {
            if (null != controller.getParent().getParent() || !((FsModel)controller.getModel()).isTouched()) continue;
            ++result;
        }
        return result;
    }

    ReadOnlyFile countBytes(ReadOnlyFile rof) {
        assert (!this.isClosed());
        return new CountingReadOnlyFile(rof);
    }

    InputStream countBytes(InputStream in) {
        assert (!this.isClosed());
        return new CountingInputStream(in);
    }

    public long getTopLevelRead() {
        return this.read;
    }

    OutputStream countBytes(OutputStream out) {
        assert (!this.isClosed());
        return new CountingOutputStream(out);
    }

    public long getTopLevelWritten() {
        return this.written;
    }

    public boolean isClosed() {
        return this != this.manager.getStatistics();
    }

    @NotThreadSafe
    private final class CountingOutputStream
    extends DecoratingOutputStream {
        CountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
            FsStatistics.this.written++;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
            FsStatistics.this.written += len;
        }
    }

    @NotThreadSafe
    private final class CountingInputStream
    extends DecoratingInputStream {
        CountingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int ret = this.delegate.read();
            if (0 < ret) {
                FsStatistics.this.read++;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ret = this.delegate.read(b, off, len);
            if (0 < ret) {
                FsStatistics.this.read += ret;
            }
            return ret;
        }
    }

    @NotThreadSafe
    private final class CountingReadOnlyFile
    extends DecoratingReadOnlyFile {
        CountingReadOnlyFile(ReadOnlyFile rof) {
            super(rof);
        }

        @Override
        public int read() throws IOException {
            int ret = this.delegate.read();
            if (0 < ret) {
                FsStatistics.this.read++;
            }
            return ret;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int ret = this.delegate.read(b, off, len);
            if (0 < ret) {
                FsStatistics.this.read += ret;
            }
            return ret;
        }
    }
}

