/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.entry.EntryName;
import de.schlichtherle.truezip.fs.FsUriModifier;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import net.jcip.annotations.Immutable;

@Immutable
public final class FsEntryName
extends EntryName {
    private static final long serialVersionUID = 2212342253466752478L;
    public static final FsEntryName ROOT = FsEntryName.create(URI.create(""));

    @NonNull
    public static FsEntryName create(@NonNull String uri) {
        return FsEntryName.create(uri, FsUriModifier.NULL);
    }

    @NonNull
    public static FsEntryName create(@NonNull String uri, @NonNull FsUriModifier modifier) {
        try {
            return new FsEntryName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static FsEntryName create(@NonNull String path, @CheckForNull String query) {
        return FsEntryName.create(path, query, FsUriModifier.NULL);
    }

    @NonNull
    public static FsEntryName create(@NonNull String path, @CheckForNull String query, @NonNull FsUriModifier modifier) {
        try {
            return new FsEntryName(new URI(null, null, path, query, null), modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @NonNull
    public static FsEntryName create(@NonNull URI uri) {
        return FsEntryName.create(uri, FsUriModifier.NULL);
    }

    @NonNull
    public static FsEntryName create(@NonNull URI uri, @NonNull FsUriModifier modifier) {
        try {
            return new FsEntryName(uri, modifier);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public FsEntryName(@NonNull String uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    public FsEntryName(@NonNull String uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        this(new URI(uri), modifier);
    }

    public FsEntryName(@NonNull URI uri) throws URISyntaxException {
        this(uri, FsUriModifier.NULL);
    }

    public FsEntryName(@NonNull URI uri, @NonNull FsUriModifier modifier) throws URISyntaxException {
        uri = modifier.modify(uri, FsUriModifier.PostFix.ENTRY_NAME);
        super(uri);
        this.parse(uri);
    }

    private void readObject(@NonNull ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            this.parse(this.getUri());
        }
        catch (URISyntaxException ex) {
            throw (InvalidObjectException)new InvalidObjectException(ex.toString()).initCause(ex);
        }
    }

    private void parse(@NonNull URI uri) throws URISyntaxException {
        String p = uri.getRawPath();
        if ("..".equals(p) || p.startsWith("/") || p.startsWith("./") || p.startsWith("../")) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal start of URI path");
        }
        if (p.endsWith("/")) {
            throw new URISyntaxException(FsEntryName.quote(uri), "Illegal separator \"/\" at end of URI path");
        }
        assert (this.invariants());
    }

    @NonNull
    private static String quote(@NonNull Object s) {
        return "\"" + s + "\"";
    }

    FsEntryName(@NonNull FsEntryName parent, @NonNull FsEntryName member) {
        super(parent, member);
        assert (this.invariants());
    }

    private boolean invariants() {
        assert (null != this.getUri());
        assert (this.getUri().normalize() == this.getUri());
        String p = this.getUri().getRawPath();
        assert (!"..".equals(p));
        assert (!p.startsWith("/"));
        assert (!p.startsWith("./"));
        assert (!p.startsWith("../"));
        assert (!p.endsWith("/"));
        return true;
    }

    public boolean isRoot() {
        URI uri = this.getUri();
        String path = uri.getRawPath();
        if (null != path && !path.isEmpty()) {
            return false;
        }
        String query = uri.getRawQuery();
        return null == query || query.isEmpty();
    }
}

